/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2.jsonextract;

import com.dropbox.client2.jsonextract.JsonBase;
import com.dropbox.client2.jsonextract.JsonExtractionException;
import com.dropbox.client2.jsonextract.JsonThing;
import java.util.Iterator;
import java.util.Map;

public final class JsonMap
extends JsonBase<Map<String, Object>>
implements Iterable<Map.Entry<String, JsonThing>> {
    public JsonMap(Map<String, Object> internal, String path) {
        super(internal, path);
    }

    public JsonMap(Map<String, Object> internal) {
        super(internal);
    }

    private static boolean isIdentLike(String s) {
        if (s.length() == 0) {
            return false;
        }
        if (!JsonMap.isEnglishLetter(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (JsonMap.isEnglishLetter(c) || JsonMap.isEnglishDigit(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEnglishLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static boolean isEnglishDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static String pathConcatField(String path, String fieldName) {
        String suffix = fieldName;
        if (!JsonMap.isIdentLike(fieldName)) {
            suffix = '\"' + fieldName + '\"';
        }
        return JsonThing.pathConcat(path, suffix);
    }

    public JsonThing get(String fieldName) throws JsonExtractionException {
        if (!((Map)this.internal).containsKey(fieldName)) {
            throw this.error("expecting object to have field \"" + fieldName + "\", but it does not");
        }
        return new JsonThing(((Map)this.internal).get(fieldName), JsonMap.pathConcatField(this.path, fieldName));
    }

    public JsonThing getOrNull(String fieldName) {
        if (!((Map)this.internal).containsKey(fieldName)) {
            return null;
        }
        return new JsonThing(((Map)this.internal).get(fieldName), JsonMap.pathConcatField(this.path, fieldName));
    }

    @Override
    public Iterator<Map.Entry<String, JsonThing>> iterator() {
        return new WrapperIterator(this.path, ((Map)this.internal).entrySet().iterator());
    }

    private static final class WrappedEntry
    implements Map.Entry<String, JsonThing> {
        private final String key;
        private final JsonThing value;

        private WrappedEntry(String path, Map.Entry<String, Object> original) {
            this.key = original.getKey();
            this.value = new JsonThing(original.getValue(), JsonMap.pathConcatField(path, this.key));
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public JsonThing getValue() {
            return this.value;
        }

        @Override
        public JsonThing setValue(JsonThing jsonThing) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class WrapperIterator
    implements Iterator<Map.Entry<String, JsonThing>> {
        private final String path;
        private final Iterator<Map.Entry<String, Object>> internal;

        private WrapperIterator(String path, Iterator<Map.Entry<String, Object>> internal) {
            this.path = path;
            this.internal = internal;
        }

        @Override
        public boolean hasNext() {
            return this.internal.hasNext();
        }

        @Override
        public Map.Entry<String, JsonThing> next() {
            return new WrappedEntry(this.path, this.internal.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("can't remove");
        }
    }
}

