/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.util.Internal;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.ISDTContents;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblCellMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;

public class XWPFTable
implements IBodyElement,
ISDTContents {
    protected StringBuffer text = new StringBuffer();
    private CTTbl ctTbl;
    protected List<XWPFTableRow> tableRows;
    protected List<String> styleIDs;
    private static EnumMap<XWPFBorderType, STBorder.Enum> xwpfBorderTypeMap = new EnumMap(XWPFBorderType.class);
    private static HashMap<Integer, XWPFBorderType> stBorderTypeMap;
    protected IBody part;

    public XWPFTable(CTTbl table, IBody part, int row, int col) {
        this(table, part);
        for (int i = 0; i < row; ++i) {
            XWPFTableRow tabRow = this.getRow(i) == null ? this.createRow() : this.getRow(i);
            for (int k = 0; k < col; ++k) {
                if (tabRow.getCell(k) != null) continue;
                tabRow.createCell();
            }
        }
    }

    public XWPFTable(CTTbl table, IBody part) {
        this.part = part;
        this.ctTbl = table;
        this.tableRows = new ArrayList<XWPFTableRow>();
        if (table.sizeOfTrArray() == 0) {
            this.createEmptyTable(table);
        }
        for (CTRow row : table.getTrArray()) {
            StringBuilder rowText = new StringBuilder();
            XWPFTableRow tabRow = new XWPFTableRow(row, this);
            this.tableRows.add(tabRow);
            for (CTTc cell : row.getTcArray()) {
                for (CTP ctp : cell.getPArray()) {
                    XWPFParagraph p = new XWPFParagraph(ctp, part);
                    if (rowText.length() > 0) {
                        rowText.append('\t');
                    }
                    rowText.append(p.getText());
                }
            }
            if (rowText.length() <= 0) continue;
            this.text.append((CharSequence)rowText);
            this.text.append('\n');
        }
    }

    private void createEmptyTable(CTTbl table) {
        table.addNewTr().addNewTc().addNewP();
        CTTblPr tblpro = table.addNewTblPr();
        tblpro.addNewTblW().setW(new BigInteger("0"));
        tblpro.getTblW().setType(STTblWidth.AUTO);
        CTTblBorders borders = tblpro.addNewTblBorders();
        borders.addNewBottom().setVal(STBorder.SINGLE);
        borders.addNewInsideH().setVal(STBorder.SINGLE);
        borders.addNewInsideV().setVal(STBorder.SINGLE);
        borders.addNewLeft().setVal(STBorder.SINGLE);
        borders.addNewRight().setVal(STBorder.SINGLE);
        borders.addNewTop().setVal(STBorder.SINGLE);
        this.getRows();
    }

    @Internal
    public CTTbl getCTTbl() {
        return this.ctTbl;
    }

    public String getText() {
        return this.text.toString();
    }

    public void addNewRowBetween(int start, int end) {
    }

    public void addNewCol() {
        if (this.ctTbl.sizeOfTrArray() == 0) {
            this.createRow();
        }
        for (int i = 0; i < this.ctTbl.sizeOfTrArray(); ++i) {
            XWPFTableRow tabRow = new XWPFTableRow(this.ctTbl.getTrArray(i), this);
            tabRow.createCell();
        }
    }

    public XWPFTableRow createRow() {
        int sizeCol = this.ctTbl.sizeOfTrArray() > 0 ? this.ctTbl.getTrArray(0).sizeOfTcArray() : 0;
        XWPFTableRow tabRow = new XWPFTableRow(this.ctTbl.addNewTr(), this);
        this.addColumn(tabRow, sizeCol);
        this.tableRows.add(tabRow);
        return tabRow;
    }

    public XWPFTableRow getRow(int pos) {
        if (pos >= 0 && pos < this.ctTbl.sizeOfTrArray()) {
            return this.getRows().get(pos);
        }
        return null;
    }

    public void setWidth(int width) {
        CTTblPr tblPr = this.getTrPr();
        CTTblWidth tblWidth = tblPr.isSetTblW() ? tblPr.getTblW() : tblPr.addNewTblW();
        tblWidth.setW(new BigInteger("" + width));
    }

    public int getWidth() {
        CTTblPr tblPr = this.getTrPr();
        return tblPr.isSetTblW() ? tblPr.getTblW().getW().intValue() : -1;
    }

    public int getNumberOfRows() {
        return this.ctTbl.sizeOfTrArray();
    }

    private CTTblPr getTrPr() {
        return this.ctTbl.getTblPr() != null ? this.ctTbl.getTblPr() : this.ctTbl.addNewTblPr();
    }

    private void addColumn(XWPFTableRow tabRow, int sizeCol) {
        if (sizeCol > 0) {
            for (int i = 0; i < sizeCol; ++i) {
                tabRow.createCell();
            }
        }
    }

    public String getStyleID() {
        CTString styleStr;
        String styleId = null;
        CTTblPr tblPr = this.ctTbl.getTblPr();
        if (tblPr != null && (styleStr = tblPr.getTblStyle()) != null) {
            styleId = styleStr.getVal();
        }
        return styleId;
    }

    public void setStyleID(String styleName) {
        CTTblPr tblPr = this.getTrPr();
        CTString styleStr = tblPr.getTblStyle();
        if (styleStr == null) {
            styleStr = tblPr.addNewTblStyle();
        }
        styleStr.setVal(styleName);
    }

    public XWPFBorderType getInsideHBorderType() {
        CTTblBorders ctb;
        XWPFBorderType bt = null;
        CTTblPr tblPr = this.getTrPr();
        if (tblPr.isSetTblBorders() && (ctb = tblPr.getTblBorders()).isSetInsideH()) {
            CTBorder border = ctb.getInsideH();
            bt = stBorderTypeMap.get(border.getVal().intValue());
        }
        return bt;
    }

    public int getInsideHBorderSize() {
        CTTblBorders ctb;
        int size = -1;
        CTTblPr tblPr = this.getTrPr();
        if (tblPr.isSetTblBorders() && (ctb = tblPr.getTblBorders()).isSetInsideH()) {
            CTBorder border = ctb.getInsideH();
            size = border.getSz().intValue();
        }
        return size;
    }

    public int getInsideHBorderSpace() {
        CTTblBorders ctb;
        int space = -1;
        CTTblPr tblPr = this.getTrPr();
        if (tblPr.isSetTblBorders() && (ctb = tblPr.getTblBorders()).isSetInsideH()) {
            CTBorder border = ctb.getInsideH();
            space = border.getSpace().intValue();
        }
        return space;
    }

    public String getInsideHBorderColor() {
        CTTblBorders ctb;
        String color = null;
        CTTblPr tblPr = this.getTrPr();
        if (tblPr.isSetTblBorders() && (ctb = tblPr.getTblBorders()).isSetInsideH()) {
            CTBorder border = ctb.getInsideH();
            color = border.xgetColor().getStringValue();
        }
        return color;
    }

    public XWPFBorderType getInsideVBorderType() {
        CTTblBorders ctb;
        XWPFBorderType bt = null;
        CTTblPr tblPr = this.getTrPr();
        if (tblPr.isSetTblBorders() && (ctb = tblPr.getTblBorders()).isSetInsideV()) {
            CTBorder border = ctb.getInsideV();
            bt = stBorderTypeMap.get(border.getVal().intValue());
        }
        return bt;
    }

    public int getInsideVBorderSize() {
        CTTblBorders ctb;
        int size = -1;
        CTTblPr tblPr = this.getTrPr();
        if (tblPr.isSetTblBorders() && (ctb = tblPr.getTblBorders()).isSetInsideV()) {
            CTBorder border = ctb.getInsideV();
            size = border.getSz().intValue();
        }
        return size;
    }

    public int getInsideVBorderSpace() {
        CTTblBorders ctb;
        int space = -1;
        CTTblPr tblPr = this.getTrPr();
        if (tblPr.isSetTblBorders() && (ctb = tblPr.getTblBorders()).isSetInsideV()) {
            CTBorder border = ctb.getInsideV();
            space = border.getSpace().intValue();
        }
        return space;
    }

    public String getInsideVBorderColor() {
        CTTblBorders ctb;
        String color = null;
        CTTblPr tblPr = this.getTrPr();
        if (tblPr.isSetTblBorders() && (ctb = tblPr.getTblBorders()).isSetInsideV()) {
            CTBorder border = ctb.getInsideV();
            color = border.xgetColor().getStringValue();
        }
        return color;
    }

    public int getRowBandSize() {
        int size = 0;
        CTTblPr tblPr = this.getTrPr();
        if (tblPr.isSetTblStyleRowBandSize()) {
            CTDecimalNumber rowSize = tblPr.getTblStyleRowBandSize();
            size = rowSize.getVal().intValue();
        }
        return size;
    }

    public void setRowBandSize(int size) {
        CTTblPr tblPr = this.getTrPr();
        CTDecimalNumber rowSize = tblPr.isSetTblStyleRowBandSize() ? tblPr.getTblStyleRowBandSize() : tblPr.addNewTblStyleRowBandSize();
        rowSize.setVal(BigInteger.valueOf(size));
    }

    public int getColBandSize() {
        int size = 0;
        CTTblPr tblPr = this.getTrPr();
        if (tblPr.isSetTblStyleColBandSize()) {
            CTDecimalNumber colSize = tblPr.getTblStyleColBandSize();
            size = colSize.getVal().intValue();
        }
        return size;
    }

    public void setColBandSize(int size) {
        CTTblPr tblPr = this.getTrPr();
        CTDecimalNumber colSize = tblPr.isSetTblStyleColBandSize() ? tblPr.getTblStyleColBandSize() : tblPr.addNewTblStyleColBandSize();
        colSize.setVal(BigInteger.valueOf(size));
    }

    public void setInsideHBorder(XWPFBorderType type, int size, int space, String rgbColor) {
        CTTblPr tblPr = this.getTrPr();
        CTTblBorders ctb = tblPr.isSetTblBorders() ? tblPr.getTblBorders() : tblPr.addNewTblBorders();
        CTBorder b = ctb.isSetInsideH() ? ctb.getInsideH() : ctb.addNewInsideH();
        b.setVal(xwpfBorderTypeMap.get((Object)type));
        b.setSz(BigInteger.valueOf(size));
        b.setSpace(BigInteger.valueOf(space));
        b.setColor((Object)rgbColor);
    }

    public void setInsideVBorder(XWPFBorderType type, int size, int space, String rgbColor) {
        CTTblPr tblPr = this.getTrPr();
        CTTblBorders ctb = tblPr.isSetTblBorders() ? tblPr.getTblBorders() : tblPr.addNewTblBorders();
        CTBorder b = ctb.isSetInsideV() ? ctb.getInsideV() : ctb.addNewInsideV();
        b.setVal(xwpfBorderTypeMap.get((Object)type));
        b.setSz(BigInteger.valueOf(size));
        b.setSpace(BigInteger.valueOf(space));
        b.setColor((Object)rgbColor);
    }

    public int getCellMarginTop() {
        CTTblWidth tw;
        int margin = 0;
        CTTblPr tblPr = this.getTrPr();
        CTTblCellMar tcm = tblPr.getTblCellMar();
        if (tcm != null && (tw = tcm.getTop()) != null) {
            margin = tw.getW().intValue();
        }
        return margin;
    }

    public int getCellMarginLeft() {
        CTTblWidth tw;
        int margin = 0;
        CTTblPr tblPr = this.getTrPr();
        CTTblCellMar tcm = tblPr.getTblCellMar();
        if (tcm != null && (tw = tcm.getLeft()) != null) {
            margin = tw.getW().intValue();
        }
        return margin;
    }

    public int getCellMarginBottom() {
        CTTblWidth tw;
        int margin = 0;
        CTTblPr tblPr = this.getTrPr();
        CTTblCellMar tcm = tblPr.getTblCellMar();
        if (tcm != null && (tw = tcm.getBottom()) != null) {
            margin = tw.getW().intValue();
        }
        return margin;
    }

    public int getCellMarginRight() {
        CTTblWidth tw;
        int margin = 0;
        CTTblPr tblPr = this.getTrPr();
        CTTblCellMar tcm = tblPr.getTblCellMar();
        if (tcm != null && (tw = tcm.getRight()) != null) {
            margin = tw.getW().intValue();
        }
        return margin;
    }

    public void setCellMargins(int top, int left, int bottom, int right) {
        CTTblPr tblPr = this.getTrPr();
        CTTblCellMar tcm = tblPr.isSetTblCellMar() ? tblPr.getTblCellMar() : tblPr.addNewTblCellMar();
        CTTblWidth tw = tcm.isSetLeft() ? tcm.getLeft() : tcm.addNewLeft();
        tw.setType(STTblWidth.DXA);
        tw.setW(BigInteger.valueOf(left));
        tw = tcm.isSetTop() ? tcm.getTop() : tcm.addNewTop();
        tw.setType(STTblWidth.DXA);
        tw.setW(BigInteger.valueOf(top));
        tw = tcm.isSetBottom() ? tcm.getBottom() : tcm.addNewBottom();
        tw.setType(STTblWidth.DXA);
        tw.setW(BigInteger.valueOf(bottom));
        tw = tcm.isSetRight() ? tcm.getRight() : tcm.addNewRight();
        tw.setType(STTblWidth.DXA);
        tw.setW(BigInteger.valueOf(right));
    }

    public void addRow(XWPFTableRow row) {
        this.ctTbl.addNewTr();
        this.ctTbl.setTrArray(this.getNumberOfRows() - 1, row.getCtRow());
        this.tableRows.add(row);
    }

    public boolean addRow(XWPFTableRow row, int pos) {
        if (pos >= 0 && pos <= this.tableRows.size()) {
            this.ctTbl.insertNewTr(pos);
            this.ctTbl.setTrArray(pos, row.getCtRow());
            this.tableRows.add(pos, row);
            return true;
        }
        return false;
    }

    public XWPFTableRow insertNewTableRow(int pos) {
        if (pos >= 0 && pos <= this.tableRows.size()) {
            CTRow row = this.ctTbl.insertNewTr(pos);
            XWPFTableRow tableRow = new XWPFTableRow(row, this);
            this.tableRows.add(pos, tableRow);
            return tableRow;
        }
        return null;
    }

    public boolean removeRow(int pos) throws IndexOutOfBoundsException {
        if (pos >= 0 && pos < this.tableRows.size()) {
            if (this.ctTbl.sizeOfTrArray() > 0) {
                this.ctTbl.removeTr(pos);
            }
            this.tableRows.remove(pos);
            return true;
        }
        return false;
    }

    public List<XWPFTableRow> getRows() {
        return this.tableRows;
    }

    @Override
    public BodyElementType getElementType() {
        return BodyElementType.TABLE;
    }

    @Override
    public IBody getBody() {
        return this.part;
    }

    @Override
    public POIXMLDocumentPart getPart() {
        if (this.part != null) {
            return this.part.getPart();
        }
        return null;
    }

    @Override
    public BodyType getPartType() {
        return this.part.getPartType();
    }

    public XWPFTableRow getRow(CTRow row) {
        for (int i = 0; i < this.getRows().size(); ++i) {
            if (this.getRows().get(i).getCtRow() != row) continue;
            return this.getRow(i);
        }
        return null;
    }

    static {
        xwpfBorderTypeMap.put(XWPFBorderType.NIL, STBorder.Enum.forInt((int)1));
        xwpfBorderTypeMap.put(XWPFBorderType.NONE, STBorder.Enum.forInt((int)2));
        xwpfBorderTypeMap.put(XWPFBorderType.SINGLE, STBorder.Enum.forInt((int)3));
        xwpfBorderTypeMap.put(XWPFBorderType.THICK, STBorder.Enum.forInt((int)4));
        xwpfBorderTypeMap.put(XWPFBorderType.DOUBLE, STBorder.Enum.forInt((int)5));
        xwpfBorderTypeMap.put(XWPFBorderType.DOTTED, STBorder.Enum.forInt((int)6));
        xwpfBorderTypeMap.put(XWPFBorderType.DASHED, STBorder.Enum.forInt((int)7));
        xwpfBorderTypeMap.put(XWPFBorderType.DOT_DASH, STBorder.Enum.forInt((int)8));
        stBorderTypeMap = new HashMap();
        stBorderTypeMap.put(1, XWPFBorderType.NIL);
        stBorderTypeMap.put(2, XWPFBorderType.NONE);
        stBorderTypeMap.put(3, XWPFBorderType.SINGLE);
        stBorderTypeMap.put(4, XWPFBorderType.THICK);
        stBorderTypeMap.put(5, XWPFBorderType.DOUBLE);
        stBorderTypeMap.put(6, XWPFBorderType.DOTTED);
        stBorderTypeMap.put(7, XWPFBorderType.DASHED);
        stBorderTypeMap.put(8, XWPFBorderType.DOT_DASH);
    }

    public static enum XWPFBorderType {
        NIL,
        NONE,
        SINGLE,
        THICK,
        DOUBLE,
        DOTTED,
        DASHED,
        DOT_DASH;

    }
}

