/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.CharacterStreamDescriptor;
import org.apache.derby.iapi.types.PositionedStream;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.Util;

public final class UTF8Reader
extends Reader {
    private static final String READER_CLOSED = "Reader closed";
    private static final int MAXIMUM_BUFFER_SIZE = 8192;
    private InputStream in;
    private final PositionedStream positionedIn;
    private long rawStreamPos = 0L;
    private long utfCount;
    private long readerCharCount;
    private final char[] buffer;
    private int charactersInBuffer;
    private int readPositionInBuffer;
    private boolean noMoreReads;
    private ConnectionChild parent;
    private final CharacterStreamDescriptor csd;

    public UTF8Reader(CharacterStreamDescriptor characterStreamDescriptor, ConnectionChild connectionChild, Object object) throws IOException {
        super(object);
        this.csd = characterStreamDescriptor;
        this.positionedIn = characterStreamDescriptor.isPositionAware() ? characterStreamDescriptor.getPositionedStream() : null;
        this.parent = connectionChild;
        int n = this.calculateBufferSize(characterStreamDescriptor);
        this.buffer = new char[n];
        if (characterStreamDescriptor.isPositionAware()) {
            this.rawStreamPos = this.positionedIn.getPosition();
            if (this.rawStreamPos < characterStreamDescriptor.getDataOffset()) {
                this.rawStreamPos = characterStreamDescriptor.getDataOffset();
            }
        } else if (characterStreamDescriptor.getCurBytePos() < characterStreamDescriptor.getDataOffset()) {
            characterStreamDescriptor.getStream().skip(characterStreamDescriptor.getDataOffset() - characterStreamDescriptor.getCurBytePos());
        }
        this.in = characterStreamDescriptor.isBufferable() ? new BufferedInputStream(characterStreamDescriptor.getStream(), n) : characterStreamDescriptor.getStream();
        this.utfCount = characterStreamDescriptor.getDataOffset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.noMoreReads) {
                throw new IOException(READER_CLOSED);
            }
            if (this.readPositionInBuffer >= this.charactersInBuffer && this.fillBuffer()) {
                return -1;
            }
            return this.buffer[this.readPositionInBuffer++];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.noMoreReads) {
                throw new IOException(READER_CLOSED);
            }
            if (this.readPositionInBuffer >= this.charactersInBuffer && this.fillBuffer()) {
                return -1;
            }
            int n3 = this.charactersInBuffer - this.readPositionInBuffer;
            if (n2 > n3) {
                n2 = n3;
            }
            System.arraycopy(this.buffer, this.readPositionInBuffer, cArray, n, n2);
            this.readPositionInBuffer += n2;
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("Number of characters to skip must be positive: " + l);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.noMoreReads) {
                throw new IOException(READER_CLOSED);
            }
            if (this.readPositionInBuffer >= this.charactersInBuffer && this.fillBuffer()) {
                return 0L;
            }
            int n = this.charactersInBuffer - this.readPositionInBuffer;
            if (l > (long)n) {
                l = n;
            }
            this.readPositionInBuffer = (int)((long)this.readPositionInBuffer + l);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.closeIn();
            this.parent = null;
            this.noMoreReads = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readInto(StringBuffer stringBuffer, int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.readPositionInBuffer >= this.charactersInBuffer && this.fillBuffer()) {
                return -1;
            }
            int n2 = this.charactersInBuffer - this.readPositionInBuffer;
            if (n > n2) {
                n = n2;
            }
            stringBuffer.append(this.buffer, this.readPositionInBuffer, n);
            this.readPositionInBuffer += n;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readAsciiInto(byte[] byArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.readPositionInBuffer >= this.charactersInBuffer && this.fillBuffer()) {
                return -1;
            }
            int n3 = this.charactersInBuffer - this.readPositionInBuffer;
            if (n2 > n3) {
                n2 = n3;
            }
            char[] cArray = this.buffer;
            for (int i = 0; i < n2; ++i) {
                char c = cArray[this.readPositionInBuffer + i];
                int n4 = c <= '\u00ff' ? (int)((byte)c) : 63;
                byArray[n + i] = n4;
            }
            this.readPositionInBuffer += n2;
            return n2;
        }
    }

    private void closeIn() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.in = null;
            }
        }
    }

    private IOException utfFormatException(String string) {
        this.noMoreReads = true;
        this.closeIn();
        return new UTFDataFormatException(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fillBuffer() throws IOException {
        if (this.in == null) {
            return true;
        }
        this.charactersInBuffer = 0;
        this.readPositionInBuffer = 0;
        try {
            try {
                int n;
                this.parent.setupContextStack();
                if (this.positionedIn != null) {
                    try {
                        this.positionedIn.reposition(this.rawStreamPos);
                    }
                    catch (StandardException standardException) {
                        throw Util.generateCsSQLException(standardException);
                    }
                }
                long l = this.csd.getByteLength();
                long l2 = this.csd.getMaxCharLength();
                block13: while (!(this.charactersInBuffer >= this.buffer.length || this.utfCount >= l && l != 0L || l2 != 0L && this.readerCharCount >= l2)) {
                    int n2;
                    n = this.in.read();
                    if (n == -1) {
                        if (l != 0L) throw this.utfFormatException("Reached EOF prematurely, read " + this.utfCount + " out of " + l + " bytes");
                        if (this.csd.isPositionAware()) break;
                        this.closeIn();
                        break;
                    }
                    switch (n >> 4) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            ++this.utfCount;
                            n2 = n;
                            break;
                        }
                        case 12: 
                        case 13: {
                            this.utfCount += 2L;
                            int n3 = this.in.read();
                            if (n3 == -1) {
                                throw this.utfFormatException("Reached EOF when reading second byte in a two byte character encoding; byte/char position " + this.utfCount + "/" + this.readerCharCount);
                            }
                            if ((n3 & 0xC0) != 128) {
                                throw this.utfFormatException("Second byte in a two bytecharacter encoding invalid: (int)" + n3 + ", byte/char pos " + this.utfCount + "/" + this.readerCharCount);
                            }
                            n2 = (n & 0x1F) << 6 | n3 & 0x3F;
                            break;
                        }
                        case 14: {
                            this.utfCount += 3L;
                            int n3 = this.in.read();
                            int n4 = this.in.read();
                            if (n3 == -1) throw this.utfFormatException("Reached EOF when reading second/third byte in a three byte character encoding; byte/char position " + this.utfCount + "/" + this.readerCharCount);
                            if (n4 == -1) {
                                throw this.utfFormatException("Reached EOF when reading second/third byte in a three byte character encoding; byte/char position " + this.utfCount + "/" + this.readerCharCount);
                            }
                            if (n == 224 && n3 == 0 && n4 == 0) {
                                if (l != 0L) throw this.utfFormatException("Internal error: Derby-specific EOF marker read");
                                if (this.csd.isPositionAware()) break block13;
                                this.closeIn();
                                break block13;
                            }
                            if ((n3 & 0xC0) != 128) throw this.utfFormatException("Second/third byte in a three byte character encoding invalid: (int)" + n3 + "/" + n4 + ", byte/char pos " + this.utfCount + "/" + this.readerCharCount);
                            if ((n4 & 0xC0) != 128) {
                                throw this.utfFormatException("Second/third byte in a three byte character encoding invalid: (int)" + n3 + "/" + n4 + ", byte/char pos " + this.utfCount + "/" + this.readerCharCount);
                            }
                            n2 = (n & 0xF) << 12 | (n3 & 0x3F) << 6 | (n4 & 0x3F) << 0;
                            break;
                        }
                        default: {
                            throw this.utfFormatException("Invalid UTF encoding at byte/char position " + this.utfCount + "/" + this.readerCharCount + ": (int)" + n);
                        }
                    }
                    this.buffer[this.charactersInBuffer++] = (char)n2;
                    ++this.readerCharCount;
                }
                if (l != 0L && this.utfCount > l) {
                    throw this.utfFormatException("Incorrect encoded length in stream, expected " + l + ", have " + this.utfCount + " bytes");
                }
                if (this.charactersInBuffer != 0) {
                    if (this.positionedIn != null) {
                        this.rawStreamPos = this.positionedIn.getPosition();
                    }
                    n = 0;
                    return n != 0;
                }
                if (!this.csd.isPositionAware()) {
                    this.closeIn();
                }
                n = 1;
                return n != 0;
            }
            finally {
                ConnectionChild.restoreIntrFlagIfSeen(true, this.parent.getEmbedConnection());
                this.parent.restoreContextStack();
            }
        }
        catch (SQLException sQLException) {
            throw Util.newIOException(sQLException);
        }
    }

    private void resetUTF8Reader() throws IOException, StandardException {
        this.positionedIn.reposition(this.csd.getDataOffset());
        this.utfCount = this.rawStreamPos = this.positionedIn.getPosition();
        if (this.csd.isBufferable()) {
            this.in = new BufferedInputStream(this.csd.getStream(), this.buffer.length);
        }
        this.readerCharCount = 0L;
        this.readPositionInBuffer = 0;
        this.charactersInBuffer = 0;
    }

    void reposition(long l) throws IOException, StandardException {
        long l2;
        long l3;
        if (l <= this.readerCharCount - (long)this.charactersInBuffer) {
            this.resetUTF8Reader();
        }
        if ((l3 = l - 1L - (l2 = this.readerCharCount - (long)this.charactersInBuffer + (long)this.readPositionInBuffer)) <= 0L) {
            this.readPositionInBuffer = (int)((long)this.readPositionInBuffer + l3);
        } else {
            this.persistentSkip(l3);
        }
    }

    private final int calculateBufferSize(CharacterStreamDescriptor characterStreamDescriptor) {
        int n = 8192;
        long l = characterStreamDescriptor.getCharLength();
        long l2 = characterStreamDescriptor.getMaxCharLength();
        if (l < 1L) {
            l = characterStreamDescriptor.getByteLength();
        }
        if (l > 0L && l < (long)n) {
            n = (int)l;
        }
        if (l2 > 0L && l2 < (long)n) {
            n = (int)l2;
        }
        return n;
    }

    private final void persistentSkip(long l) throws IOException {
        long l2;
        for (long i = l; i > 0L; i -= l2) {
            l2 = this.skip(i);
            if (l2 != 0L) continue;
            throw new EOFException();
        }
    }
}

