/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.jsieve;

import com.github.fge.lambdas.Throwing;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.mailets.jsieve.ActionContext;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeUtils;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionUtils.class);
    private static final String ATTRIBUTE_PREFIX = ActionUtils.class.getPackage().getName() + ".";

    public static void detectAndHandleLocalLooping(Mail aMail, ActionContext context, String anAttributeSuffix) {
        MailAddress thisRecipient = context.getRecipient();
        AttributeName attributeName = AttributeName.of((String)(ATTRIBUTE_PREFIX + anAttributeSuffix));
        AttributeUtils.getValueAndCastFromMail((Mail)aMail, (AttributeName)attributeName, String.class).filter(Throwing.predicate(lastRecipient -> new MailAddress(lastRecipient).equals((Object)thisRecipient))).ifPresent(Throwing.consumer(any -> {
            MessagingException ex = new MessagingException("This message is looping! Message ID: " + aMail.getMessage().getMessageID());
            LOGGER.warn(ex.getMessage(), (Throwable)ex);
            throw ex;
        }).sneakyThrow());
        aMail.setAttribute(new Attribute(attributeName, AttributeValue.of((String)thisRecipient.asString())));
    }
}

