/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.adapter.mailbox;

import com.github.fge.lambdas.Throwing;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.user.api.UsernameChangeTaskStep;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MailboxUsernameChangeTaskStep
implements UsernameChangeTaskStep {
    private final StoreMailboxManager mailboxManager;
    private final SubscriptionManager subscriptionManager;

    @Inject
    public MailboxUsernameChangeTaskStep(StoreMailboxManager mailboxManager, SubscriptionManager subscriptionManager) {
        this.mailboxManager = mailboxManager;
        this.subscriptionManager = subscriptionManager;
    }

    public UsernameChangeTaskStep.StepName name() {
        return new UsernameChangeTaskStep.StepName("MailboxUsernameChangeTaskStep");
    }

    public int priority() {
        return 2;
    }

    public Publisher<Void> changeUsername(Username oldUsername, Username newUsername) {
        MailboxSession fromSession = this.mailboxManager.createSystemSession(oldUsername);
        MailboxSession toSession = this.mailboxManager.createSystemSession(newUsername);
        MailboxQuery queryUser = MailboxQuery.builder().privateNamespace().user(fromSession.getUser()).build();
        return this.mailboxManager.search(queryUser, MailboxManager.MailboxSearchFetchType.Minimal, fromSession).filter(mailbox -> mailbox.getPath().getHierarchyLevels(fromSession.getPathDelimiter()).size() == 1).concatMap(mailbox -> this.migrateMailbox(fromSession, toSession, (MailboxMetaData)mailbox)).doFinally(any -> this.mailboxManager.endProcessingRequest(fromSession)).doFinally(any -> this.mailboxManager.endProcessingRequest(toSession));
    }

    private Mono<Void> migrateMailbox(MailboxSession fromSession, MailboxSession toSession, MailboxMetaData mailbox) {
        MailboxPath renamedPath = mailbox.getPath().withUser(toSession.getUser());
        return this.mailboxManager.mailboxExists(renamedPath, toSession).flatMap(exist -> {
            if (!exist.booleanValue()) {
                return this.renameMailboxAndRenameSubscriptionForDelegatee(fromSession, toSession, mailbox, renamedPath);
            }
            return this.renameWhenMailboxExist(toSession, renamedPath, this.renameMailboxAndRenameSubscriptionForDelegatee(fromSession, toSession, mailbox, renamedPath));
        });
    }

    private Mono<Void> renameMailboxAndRenameSubscriptionForDelegatee(MailboxSession fromSession, MailboxSession toSession, MailboxMetaData mailbox, MailboxPath renamedPath) {
        return this.mailboxManager.renameMailboxReactive(mailbox.getPath(), renamedPath, MailboxManager.RenameOption.RENAME_SUBSCRIPTIONS, fromSession, toSession).then(this.renameSubscriptionsForDelegatee(mailbox, renamedPath)).then();
    }

    private Mono<Void> renameWhenMailboxExist(MailboxSession toSession, MailboxPath renamedPath, Mono<Void> renamePublisher) {
        MailboxPath temporaryPath = new MailboxPath(renamedPath.getNamespace(), renamedPath.getUser(), renamedPath.getName() + "tmp");
        return this.mailboxManager.renameMailboxReactive(renamedPath, temporaryPath, MailboxManager.RenameOption.NONE, toSession).then(renamePublisher).then(this.mailboxManager.copyMessagesReactive(MessageRange.all(), temporaryPath, renamedPath, toSession).then()).then(this.mailboxManager.deleteMailboxReactive(temporaryPath, toSession));
    }

    private Mono<Void> renameSubscriptionsForDelegatee(MailboxMetaData mailbox, MailboxPath renamedPath) {
        return Flux.fromIterable(mailbox.getResolvedAcls().getEntries().entrySet()).filter(entry -> ((MailboxACL.EntryKey)entry.getKey()).getNameType() == MailboxACL.NameType.user && !((MailboxACL.EntryKey)entry.getKey()).isNegative()).map(entry -> Username.of((String)((MailboxACL.EntryKey)entry.getKey()).getName())).concatMap((Function)Throwing.function(userWithAccess -> {
            MailboxSession session = this.mailboxManager.createSystemSession(userWithAccess);
            return Flux.from((Publisher)this.subscriptionManager.subscriptionsReactive(session)).filter(subscribedMailbox -> subscribedMailbox.equals((Object)mailbox.getPath())).concatMap(any -> this.renameSubscription(mailbox, renamedPath, (Username)userWithAccess)).doFinally(any -> this.mailboxManager.endProcessingRequest(session));
        })).then();
    }

    private Mono<Void> renameSubscription(MailboxMetaData mailbox, MailboxPath renamedPath, Username user) {
        MailboxSession session = this.mailboxManager.createSystemSession(user);
        return Mono.from((Publisher)this.subscriptionManager.subscribeReactive(renamedPath, session)).then(Mono.from((Publisher)this.subscriptionManager.unsubscribeReactive(mailbox.getPath(), session))).doFinally(any -> this.mailboxManager.endProcessingRequest(session));
    }
}

