/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.protocols;

import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.probe.SieveProbe;
import org.apache.james.sieverepository.api.ScriptContent;
import org.apache.james.sieverepository.api.ScriptName;
import org.apache.james.sieverepository.api.SieveRepository;
import org.apache.james.utils.GuiceProbe;

public class SieveProbeImpl
implements GuiceProbe,
SieveProbe {
    private final SieveRepository sieveRepository;

    @Inject
    private SieveProbeImpl(SieveRepository sieveRepository) {
        this.sieveRepository = sieveRepository;
    }

    public long getSieveQuota() throws Exception {
        return this.sieveRepository.getDefaultQuota().asLong();
    }

    public void setSieveQuota(long quota) throws Exception {
        this.sieveRepository.setDefaultQuota(QuotaSizeLimit.size((long)quota));
    }

    public void removeSieveQuota() throws Exception {
        this.sieveRepository.removeQuota();
    }

    public long getSieveQuota(String user) throws Exception {
        return this.sieveRepository.getQuota(Username.of((String)user)).asLong();
    }

    public void setSieveQuota(String user, long quota) throws Exception {
        this.sieveRepository.setQuota(Username.of((String)user), QuotaSizeLimit.size((long)quota));
    }

    public void removeSieveQuota(String user) throws Exception {
        this.sieveRepository.removeQuota(Username.of((String)user));
    }

    public void addActiveSieveScript(String userName, String name, String script) throws Exception {
        Username username = Username.of((String)userName);
        this.sieveRepository.putScript(username, new ScriptName(name), new ScriptContent(script));
        this.sieveRepository.setActive(username, new ScriptName(name));
    }
}

