/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action.dbimport;

import java.awt.event.ActionEvent;
import javax.swing.tree.TreePath;
import org.apache.cayenne.dbsync.reverse.dbimport.FilterContainer;
import org.apache.cayenne.dbsync.reverse.dbimport.PatternParam;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.dbimport.TreeManipulationAction;
import org.apache.cayenne.modeler.editor.dbimport.DbImportSorter;
import org.apache.cayenne.util.Util;

public class EditNodeAction
extends TreeManipulationAction {
    private static final String ACTION_NAME = "Rename";
    private static final String ICON_NAME = "icon-edit.png";
    private String actionName;

    public EditNodeAction(Application application) {
        super(ACTION_NAME, application);
    }

    @Override
    public String getIconName() {
        return ICON_NAME;
    }

    @Override
    public void performAction(ActionEvent e) {
        if (this.tree.isEditing()) {
            return;
        }
        if (e != null && this.tree.getSelectionPath() != null) {
            this.tree.startEditingAtPath(this.tree.getSelectionPath());
        }
        if (this.actionName == null) {
            return;
        }
        if (this.tree.getSelectionPath() != null) {
            this.selectedElement = this.tree.getSelectedNode();
            this.parentElement = this.selectedElement.getParent();
            if (this.parentElement != null) {
                Object selectedObject = this.selectedElement.getUserObject();
                ReverseEngineering reverseEngineeringOldCopy = new ReverseEngineering(this.tree.getReverseEngineering());
                if (!Util.isEmptyString(this.actionName)) {
                    if (selectedObject instanceof FilterContainer) {
                        ((FilterContainer)selectedObject).setName(this.actionName);
                    } else if (selectedObject instanceof PatternParam) {
                        ((PatternParam)selectedObject).setPattern(this.actionName);
                    }
                    this.updateModel(true);
                }
                if (!this.actionName.equals("")) {
                    this.putReverseEngineeringToUndoManager(reverseEngineeringOldCopy);
                }
            }
            DbImportSorter.sortSingleNode(this.selectedElement.getParent(), DbImportSorter.NODE_COMPARATOR_BY_TYPE);
            this.tree.reloadModelKeepingExpanded();
            this.tree.setSelectionPath(new TreePath(this.selectedElement.getPath()));
            this.selectedElement = null;
        }
    }

    public void setActionName(String name) {
        this.actionName = name;
    }
}

