/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.value;

import org.apache.cayenne.crypto.transformer.value.BytesConverter;

public class BooleanConverter
implements BytesConverter<Boolean> {
    public static final BytesConverter<Boolean> INSTANCE = new BooleanConverter();

    @Override
    public Boolean fromBytes(byte[] bytes) {
        if (bytes.length != 1) {
            throw new IllegalArgumentException("Unexpected number of bytes for boolean: " + bytes.length);
        }
        byte b = bytes[0];
        if (b == 0) {
            return Boolean.FALSE;
        }
        if (b == 1) {
            return Boolean.TRUE;
        }
        throw new IllegalArgumentException("Unexpected byte value for boolean: " + b);
    }

    @Override
    public byte[] toBytes(Boolean value) {
        return new byte[]{value != false ? (byte)1 : 0};
    }
}

