/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rampart.saml;

import javax.security.auth.callback.CallbackHandler;
import org.apache.axiom.om.OMElement;
import org.apache.rahas.TrustException;
import org.apache.rahas.impl.util.SAMLUtils;
import org.apache.rampart.TokenCallbackHandler;
import org.apache.rampart.saml.SAMLAssertionHandler;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SAMLKeyInfoProcessor;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.saml.WSSSAMLKeyInfoProcessor;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Conditions;

public class SAML1AssertionHandler
extends SAMLAssertionHandler {
    private Assertion assertion;

    public SAML1AssertionHandler(Assertion saml1Assertion) {
        this.assertion = saml1Assertion;
        this.processSAMLAssertion();
    }

    @Override
    public boolean isBearerAssertion() {
        return "urn:oasis:names:tc:SAML:1.0:cm:bearer".equals(SAMLUtils.getSAML11SubjectConfirmationMethod((Assertion)this.assertion));
    }

    @Override
    protected void processSAMLAssertion() {
        this.setAssertionId(this.assertion.getID());
        if (this.assertion.getConditions() != null) {
            Conditions conditions = this.assertion.getConditions();
            if (conditions.getNotBefore() != null) {
                this.setDateNotBefore(conditions.getNotBefore());
            }
            if (conditions.getNotOnOrAfter() != null) {
                this.setDateNotOnOrAfter(conditions.getNotOnOrAfter());
            }
        }
    }

    @Override
    public byte[] getAssertionKeyInfoSecret(Crypto signatureCrypto, TokenCallbackHandler tokenCallbackHandler, RequestData requestData) throws WSSecurityException {
        requestData.setCallbackHandler((CallbackHandler)tokenCallbackHandler);
        requestData.setSigVerCrypto(signatureCrypto);
        WSDocInfo docInfo = new WSDocInfo(this.assertion.getDOM().getOwnerDocument());
        SAMLKeyInfo samlKi = SAMLUtil.getCredentialFromSubject((Assertion)this.assertion, (SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(requestData), (Crypto)signatureCrypto);
        return samlKi.getSecret();
    }

    @Override
    public OMElement getAssertionElement() throws TrustException {
        return (OMElement)this.assertion.getDOM();
    }
}

