<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="html"/>

    <xsl:template match="/">
		<html>
			<head>
				<link href="icon.png" rel="SHORTCUT ICON"  />
			</head>
			<body>
				<div style="border: 1px solid silver; padding: 5px; margin-bottom: 10px;">
					<a href="start.idoc" style="margin-right: 5px; margin-left: 5px;">start</a>
					<a href="stop.idoc" style="margin-right: 5px; margin-left: 5px;">stop</a>
					<a href="status.idoc" style="margin-right: 5px; margin-left: 5px;">refresh</a>
					<a href="services/message.idoc" style="margin-right: 5px; margin-left: 5px;">view reply message</a>
					<a href="init.idoc" style="float: right;">reconfigure</a>
				</div>
				<xsl:apply-templates/>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template match="null">
		<div>
			<p>MailProcessor is not registered</p>
		</div>
	</xsl:template>
	
	<xsl:template match="mailProcessorStatus">
		<div>
			
			<table style="border: 1px solid silver; padding: 2px;">
			<tr>
				<td>MailTransport</td><td><xsl:value-of select="hostTransport"/></td>
			</tr>
			<tr>
				<td>MailProcessor</td><td><xsl:value-of select="id"/></td>
			</tr>
			<tr>
				<td colspan="3">
					<xsl:choose>
						<xsl:when test="mailProcessor/running = 'true'">
							<div style="border: 1px solid silver; padding: 2px; background-color:green; color: white; width: 200px; height: 50px; text-align: center; padding-top: 15px;">
							STARTED
							</div>
						</xsl:when>
						<xsl:otherwise>
							<div style="border: 1px solid silver; padding: 2px; background-color:red; color: black; width: 200px; height: 50px; text-align: center; padding-top: 15px;">
							STOPPED
							</div>
						</xsl:otherwise>
					</xsl:choose>
				</td>
			</tr>
			<tr>
				<td valign="top" rowspan="2"><img src="icon.png" /></td>
				<td>Messages processed</td>
				<td><xsl:value-of select="processed"/></td>
				
			</tr>
			<tr>
				<td>Messages rejected</td>
				<td><xsl:value-of select="rejected"/></td>
			</tr>
			</table>
		</div>
    </xsl:template>

</xsl:stylesheet>
