<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
	<xsl:output method="xml"/>
	<xsl:param name="errors"/>
	<xsl:template match="/nvp">
		<div title="My Profile" desc="Update your profile">
			<table style="background: url([[xrl:img-flat]]);" xrl:resolve="style">
			<tr><td>
			<form action="" xrl:resolve="action" method="POST">
				<input type="hidden" name="id" value="{id}"/>
				<input type="hidden" name="type" value="profile"/>
				<table style="background: url([[xrl:img-flat]]);" xrl:resolve="style">
					<tr>
						<td>User ID<sup>*</sup></td>
						<td><input disabled="true" title="Your prefered user id - this will be displayed along side your posts" name="userid" value="{userid}"/></td>
						<xsl:if test="$errors/b/error[@userid]">
								<td>
									<div style="border: 1px solid red; padding: 3px;">
										<xsl:for-each select="$errors/b/error[@userid]">
											<xsl:value-of select="."/><br/>
										</xsl:for-each>
									</div>
								</td>
						</xsl:if>
					</tr>

					<tr>
						<td>Email<sup>*</sup></td>
						<td><input size="50" title="This address will receive instructions to complete registration" name="email" value="{email}"/></td>
						<xsl:if test="$errors/b/error[@email]">
								<td>
									<div style="border: 1px solid red; padding: 3px;">
										<xsl:for-each select="$errors/b/error[@email]">
											<xsl:value-of select="."/><br/>
										</xsl:for-each>
									</div>
								</td>
						</xsl:if>
					</tr>
					<tr>
						<td>Web</td><td><input size="50" title="Please provide a full URL eg http://www.1060.org" name="web" value="{web}"/></td>
					</tr>
					<tr>
						<td>Image URL</td><td><input size="50" title="The URL for your image (please 60x60 px) eg http://www.1060.org/image.png" name="imageurl" value="{imageurl}"/></td>
					</tr>
					<tr>
						<td>Location</td><td><input size="40" title="Your physical location" name="location" value="{location}"/></td>
					</tr>
					<tr>
						<td>Biography</td><td><textarea title="A brief plain text biography of yourself" style="width: 400px; height 150px;" name="biog"><xsl:value-of select="biog"/></textarea></td>
					</tr>
					<tr>
						<td>Password Reminder Question</td><td><input size="50" title="A question we will ask you should you forget your password" name="reminder" value="{reminder}"/></td>
					</tr>
					<tr>
						<td>Password Reminder Answer</td><td><input size="40" title="The answer that will prove you are you!" name="answer" value="{answer}"/></td>
					</tr>
					<tr>
						<td colspan="2" style="text-align: right;"><input type="submit" name="submit" value="Update Profile"/></td>
					</tr>
				</table>
			</form>
			<hr/>
			</td></tr>
			<tr><td>
			<div style="font-weight: bold;">Change Password</div>
			<form action="" xrl:resolve="action" method="POST" >
				<table><tr><td>
				<input type="hidden" name="id" value="{id}"/>
				<input type="hidden" name="userid" value="{userid}"/>
				<input type="hidden" name="email" value="{email}"/>
				<input type="hidden" name="web" value="{web}"/>
				<input type="hidden" name="imageurl" value="{imageurl}"/>
				<input type="hidden" name="location" value="{location}"/>
				<input type="hidden" name="biog" value="{biog}"/>
				<input type="hidden" name="reminder" value="{reminder}"/>
				<input type="hidden" name="answer" value="{answer}"/>
				<input type="hidden" name="type" value="password"/>
				<table>
					<tr>
						<td>Password<sup>*</sup></td><td><input type="password" name="password" value="{password}"/></td>
						<xsl:if test="$errors/b/error[@password]">
								<td>
									<div style="border: 1px solid red; padding: 3px;">
										<xsl:for-each select="$errors/b/error[@password]">
											<xsl:value-of select="."/><br/>
										</xsl:for-each>
									</div>
								</td>
						</xsl:if>
					</tr>
					<tr>
						<td>Password (Repeat)<sup>*</sup></td><td><input type="password" name="password2" value="{password2}"/></td>
					</tr>
					<tr>
						<td colspan="2" style="text-align: right;"><input type="submit" name="submit" value="Change Password"/></td>
					</tr>
				</table>
			</td></tr></table>
			</form>
			</td></tr>
			</table>
		</div>
	</xsl:template>
</xsl:stylesheet> 
