/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.amd64;

import sun.jvm.hotspot.asm.Register;
import sun.jvm.hotspot.asm.amd64.AMD64FloatRegisters;

public class AMD64FloatRegister
extends Register {
    public AMD64FloatRegister(int number) {
        super(number);
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public int getNumberOfRegisters() {
        return AMD64FloatRegisters.getNumRegisters();
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public boolean isFramePointer() {
        return false;
    }

    @Override
    public boolean isStackPointer() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.number >= 0 && this.number < AMD64FloatRegisters.getNumRegisters();
    }

    public String toString() {
        return AMD64FloatRegisters.getRegisterName(this.number);
    }
}

