"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = void 0;
const language_service_1 = require("@volar/language-service");
function register(htmlLs) {
    return (pugDoc, posArr) => {
        const htmlPosArr = posArr
            .map(position => pugDoc.map.toGeneratedPosition(position))
            .filter((v) => !!v);
        const htmlResult = htmlLs.getSelectionRanges(pugDoc.map.virtualFileDocument, htmlPosArr);
        return language_service_1.transformer.asLocations(htmlResult, htmlRange => pugDoc.map.toSourceRange(htmlRange));
    };
}
exports.register = register;
//# sourceMappingURL=selectionRanges.js.map