/* Intel Alder Lake gmp-mparam.h -- Compiler/machine parameter header file.

Copyright 2022 Free Software Foundation, Inc.

This file is part of the GNU MP Library.

The GNU MP Library is free software; you can redistribute it and/or modify
it under the terms of either:

  * the GNU Lesser General Public License as published by the Free
    Software Foundation; either version 3 of the License, or (at your
    option) any later version.

or

  * the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any
    later version.

or both in parallel, as here.

The GNU MP Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received copies of the GNU General Public License and the
GNU Lesser General Public License along with the GNU MP Library.  If not,
see https://www.gnu.org/licenses/.  */

#define GMP_LIMB_BITS 64
#define GMP_LIMB_BYTES 8

/* Disable use of slow functions.  FIXME: We should disable lib inclusion.  */
#undef HAVE_NATIVE_mpn_mul_2
#undef HAVE_NATIVE_mpn_addmul_2

/* 3700-4900 MHz Alder Lake */
/* FFT tuning limit = 10,000,000 */
/* Generated by tuneup.c, 2022-03-15, gcc 11.2 */

#define MOD_1_NORM_THRESHOLD             MP_SIZE_T_MAX  /* never */
#define MOD_1_UNNORM_THRESHOLD           MP_SIZE_T_MAX  /* never */
#define MOD_1N_TO_MOD_1_1_THRESHOLD          5
#define MOD_1U_TO_MOD_1_1_THRESHOLD          4
#define MOD_1_1_TO_MOD_1_2_THRESHOLD        12
#define MOD_1_2_TO_MOD_1_4_THRESHOLD        23
#define PREINV_MOD_1_TO_MOD_1_THRESHOLD      8
#define USE_PREINV_DIVREM_1                  1  /* native */
#define DIV_QR_1_NORM_THRESHOLD             34
#define DIV_QR_1_UNNORM_THRESHOLD        MP_SIZE_T_MAX  /* never */
#define DIV_QR_2_PI2_THRESHOLD              30
#define DIVEXACT_1_THRESHOLD                 0  /* always (native) */
#define BMOD_1_TO_MOD_1_THRESHOLD           23

#define DIV_1_VS_MUL_1_PERCENT             559

#define MUL_TOOM22_THRESHOLD                13
#define MUL_TOOM33_THRESHOLD                97
#define MUL_TOOM44_THRESHOLD               148
#define MUL_TOOM6H_THRESHOLD               562
#define MUL_TOOM8H_THRESHOLD               608

#define MUL_TOOM32_TO_TOOM43_THRESHOLD      97
#define MUL_TOOM32_TO_TOOM53_THRESHOLD     259
#define MUL_TOOM42_TO_TOOM53_THRESHOLD      98
#define MUL_TOOM42_TO_TOOM63_THRESHOLD      98
#define MUL_TOOM43_TO_TOOM54_THRESHOLD     144

#define SQR_BASECASE_THRESHOLD               0  /* always (native) */
#define SQR_TOOM2_THRESHOLD                 24
#define SQR_TOOM3_THRESHOLD                 86
#define SQR_TOOM4_THRESHOLD                582
#define SQR_TOOM6_THRESHOLD                  0  /* always */
#define SQR_TOOM8_THRESHOLD                753

#define MULMID_TOOM42_THRESHOLD             40

#define MULMOD_BNM1_THRESHOLD               13
#define SQRMOD_BNM1_THRESHOLD               16

#define MUL_FFT_MODF_THRESHOLD             384  /* k = 5 */
#define MUL_FFT_TABLE3                                      \
  { {    384, 5}, {     21, 6}, {     11, 5}, {     23, 6}, \
    {     21, 7}, {     11, 6}, {     24, 7}, {     24, 8}, \
    {     13, 7}, {     27, 8}, {     15, 7}, {     31, 8}, \
    {     23, 7}, {     47, 8}, {     27, 9}, {     15, 8}, \
    {     33, 9}, {     19, 8}, {     39, 9}, {     23, 8}, \
    {     49, 9}, {     27,10}, {     15, 9}, {     31, 8}, \
    {     63, 9}, {     39,10}, {     23, 9}, {     51,11}, \
    {     15,10}, {     31, 9}, {     71,10}, {     39, 9}, \
    {     83,10}, {     47, 9}, {     95,10}, {     55,11}, \
    {     31,10}, {     79,11}, {     47,10}, {     95,12}, \
    {     31,11}, {     63,10}, {    127, 9}, {    255, 8}, \
    {    511,10}, {    135,11}, {     79, 9}, {    319, 8}, \
    {    639, 9}, {    335, 8}, {    671,11}, {     95,12}, \
    {     63,11}, {    127,10}, {    255, 9}, {    511,10}, \
    {    271, 9}, {    543, 8}, {   1087, 9}, {    575,10}, \
    {    303, 9}, {    607,10}, {    319, 9}, {    639,10}, \
    {    335, 9}, {    671,10}, {    351,12}, {     95,11}, \
    {    191,10}, {    383,13}, {     63,12}, {    127,11}, \
    {    255,10}, {    511,11}, {    271,10}, {    543, 9}, \
    {   1087,11}, {    287,10}, {    575,11}, {    303,10}, \
    {    607, 9}, {   1215,11}, {    319,10}, {    671,11}, \
    {    351,10}, {    703,11}, {    367,10}, {    735, 9}, \
    {   1471, 8}, {   2943,12}, {    191,11}, {    383,10}, \
    {    767,11}, {    415,10}, {    831,12}, {    223,11}, \
    {    447,10}, {    895,11}, {    479,10}, {    959,13}, \
    {    127,12}, {    255,11}, {    511,10}, {   1023,11}, \
    {    543,10}, {   1087, 9}, {   2175,12}, {    287,11}, \
    {    575,10}, {   1151,11}, {    607,12}, {    319,11}, \
    {    639,10}, {   1279,11}, {    671,12}, {    351,11}, \
    {    703,10}, {   1407,11}, {    735,10}, {   1471, 9}, \
    {   2943, 8}, {   5887,12}, {    383,11}, {    767,10}, \
    {   1535,12}, {    415,11}, {    831,10}, {   1663,12}, \
    {    447,11}, {    895,10}, {   1791,12}, {    479,11}, \
    {    959,14}, {    127,13}, {    255,12}, {    511,11}, \
    {   1023,12}, {    543,11}, {   1087,12}, {    575,11}, \
    {   1151,12}, {    607,11}, {   1215,13}, {    319,12}, \
    {    639,11}, {   1279,12}, {    671,11}, {   1343,12}, \
    {    703,11}, {   1407,12}, {    735,11}, {   1471,10}, \
    {   2943,13}, {    383,12}, {    767,11}, {   1535,12}, \
    {    831,13}, {    447,12}, {    959,11}, {   1919,13}, \
    {    511,12}, {   1087,13}, {    575,12}, {   1215,13}, \
    {    639,12}, {   1343,13}, {    703,12}, {   1471,11}, \
    {   2943,14}, {    383,13}, {    767,12}, {   1535,13}, \
    {    831,12}, {   1663,13}, {    959,12}, {   1919,14}, \
    {    511,13}, {   1087,12}, {   2175,13}, {   1215,14}, \
    {  16384,15}, {  32768,16}, {  65536,17}, { 131072,18}, \
    { 262144,19}, { 524288,20}, {1048576,21}, {2097152,22}, \
    {4194304,23}, {8388608,24} }
#define MUL_FFT_TABLE3_SIZE 190
#define MUL_FFT_THRESHOLD                 2496

#define SQR_FFT_MODF_THRESHOLD             344  /* k = 5 */
#define SQR_FFT_TABLE3                                      \
  { {    344, 5}, {     21, 6}, {     11, 5}, {     23, 6}, \
    {     25, 7}, {     13, 6}, {     27, 7}, {     25, 8}, \
    {     13, 7}, {     27, 8}, {     15, 7}, {     31, 8}, \
    {     21, 9}, {     11, 8}, {     27, 9}, {     15, 8}, \
    {     35, 9}, {     19, 8}, {     41, 9}, {     23, 8}, \
    {     47, 9}, {     27,10}, {     15, 9}, {     39,10}, \
    {     23, 9}, {     51,11}, {     15,10}, {     31, 9}, \
    {     63,10}, {     39, 9}, {     79,10}, {     47,11}, \
    {     31,10}, {     79,11}, {     47,10}, {     95,12}, \
    {     31,11}, {     63,10}, {    127, 9}, {    255, 8}, \
    {    511,11}, {     79, 9}, {    319,11}, {     95,10}, \
    {    191, 9}, {    383,12}, {     63,11}, {    127,10}, \
    {    255, 9}, {    511,10}, {    271, 9}, {    543,11}, \
    {    143,10}, {    287, 9}, {    575,10}, {    303, 9}, \
    {    607,10}, {    319, 9}, {    639,12}, {     95,11}, \
    {    191,10}, {    383,13}, {     63,12}, {    127,11}, \
    {    255,10}, {    511,11}, {    271,10}, {    543,11}, \
    {    287,10}, {    575,11}, {    303,10}, {    607,11}, \
    {    319,10}, {    639,11}, {    335,10}, {    671,11}, \
    {    351,10}, {    703,12}, {    191,11}, {    383,10}, \
    {    767,11}, {    415,10}, {    831,12}, {    223,11}, \
    {    447,10}, {    895,11}, {    479,10}, {    959,13}, \
    {    127,12}, {    255,11}, {    511,10}, {   1023,11}, \
    {    543,10}, {   1087,12}, {    287,11}, {    575,10}, \
    {   1151,11}, {    607,10}, {   1215,12}, {    319,11}, \
    {    639,10}, {   1279,11}, {    671,12}, {    351,11}, \
    {    703,10}, {   1407,13}, {    191,12}, {    383,11}, \
    {    767,12}, {    415,11}, {    831,12}, {    447,11}, \
    {    895,12}, {    479,11}, {    959,10}, {   1919,14}, \
    {    127,13}, {    255,12}, {    511,11}, {   1023,12}, \
    {    543,11}, {   1087,12}, {    575,11}, {   1151,12}, \
    {    607,11}, {   1215,13}, {    319,12}, {    639,11}, \
    {   1279,12}, {    671,11}, {   1343,12}, {    703,11}, \
    {   1407,13}, {    383,12}, {    831,13}, {    447,12}, \
    {    959,14}, {    255,13}, {    511,12}, {   1087,13}, \
    {    575,12}, {   1215,13}, {    639,12}, {   1343,13}, \
    {    703,12}, {   1407,14}, {    383,13}, {    767,12}, \
    {   1535,13}, {    831,12}, {   1663,13}, {    959,14}, \
    {    511,13}, {   1087,12}, {   2175,13}, {   1215,14}, \
    {  16384,15}, {  32768,16}, {  65536,17}, { 131072,18}, \
    { 262144,19}, { 524288,20}, {1048576,21}, {2097152,22}, \
    {4194304,23}, {8388608,24} }
#define SQR_FFT_TABLE3_SIZE 166
#define SQR_FFT_THRESHOLD                 2240

#define MULLO_BASECASE_THRESHOLD             0  /* always */
#define MULLO_DC_THRESHOLD                  56
#define MULLO_MUL_N_THRESHOLD             4940
#define SQRLO_BASECASE_THRESHOLD            10
#define SQRLO_DC_THRESHOLD                  73
#define SQRLO_SQR_THRESHOLD               4392

#define DC_DIV_QR_THRESHOLD                 19
#define DC_DIVAPPR_Q_THRESHOLD             139
#define DC_BDIV_QR_THRESHOLD                62
#define DC_BDIV_Q_THRESHOLD                126

#define INV_MULMOD_BNM1_THRESHOLD           24
#define INV_NEWTON_THRESHOLD               108
#define INV_APPR_THRESHOLD                 108

#define BINV_NEWTON_THRESHOLD              208
#define REDC_1_TO_REDC_2_THRESHOLD          36
#define REDC_2_TO_REDC_N_THRESHOLD          53

#define MU_DIV_QR_THRESHOLD                855
#define MU_DIVAPPR_Q_THRESHOLD            1120
#define MUPI_DIV_QR_THRESHOLD                0  /* always */
#define MU_BDIV_QR_THRESHOLD               807
#define MU_BDIV_Q_THRESHOLD               1470

#define POWM_SEC_TABLE  1,11,70,702,2499

#define GET_STR_DC_THRESHOLD                11
#define GET_STR_PRECOMPUTE_THRESHOLD        17
#define SET_STR_DC_THRESHOLD              2150
#define SET_STR_PRECOMPUTE_THRESHOLD      2943

#define FAC_DSC_THRESHOLD                  298
#define FAC_ODD_THRESHOLD                   51

#define MATRIX22_STRASSEN_THRESHOLD         17
#define HGCD2_DIV1_METHOD                    1  /* 2.38% faster than 3 */
#define HGCD_THRESHOLD                     142
#define HGCD_APPR_THRESHOLD                159
#define HGCD_REDUCE_THRESHOLD             2384
#define GCD_DC_THRESHOLD                   483
#define GCDEXT_DC_THRESHOLD                492
#define JACOBI_BASE_METHOD                   1  /* 0.94% faster than 3 */
