# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class ResourceFileLocator(Object):
    """
    ResourceFileLocator - utility to locate resource files.
    
    Superclass: Object
    
    VTK based application often need to locate resource files, such
    configuration files, Python modules, etc. ResourceFileLocator
    provides methods that can be used to locate such resource files at
    runtime.
    
    Using `Locate`, one can locate files relative to an anchor directory
    such as the executable directory, or the library directory.
    
    `_get_library_path_for_symbol_unix` and `_get_library_path_for_symbol_win32`
    methods can be used to locate the library that provides a particular
    symbol. For example, this is used by `vtk_python_interpreter` to ensure
    that the `vtk` Python package is located relative the VTK libraries,
    irrespective of the application location.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkResourceFileLocator, obj, update, **traits)
    
    print_debug_information = tvtk_base.false_bool_trait(desc=\
        """
        Enable/disable printing of testing of various path during
        `Locate` to `stdout`.
        """
    )

    def _print_debug_information_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPrintDebugInformation,
                        self.print_debug_information_)

    def get_library_path_for_symbol_unix(self, *args):
        """
        V.get_library_path_for_symbol_unix(string) -> string
        C++: static std::string GetLibraryPathForSymbolUnix(
            const char *symbolname)
        Returns the name of the library providing the symbol. For
        example, if you want to locate where the VTK libraries located
        call `_get_library_path_for_symbol_unix("_get_vtk_version")` on Unixes and
        `_get_library_path_for_symbol_win32(_get_vtk_version)` on Windows.
        Alternatively, you can simply use the
        `vtk_get_library_path_for_symbol(_get_vtk_version)` macro that makes the
        appropriate call as per the current platform.
        """
        ret = self._wrap_call(self._vtk_obj.GetLibraryPathForSymbolUnix, *args)
        return ret

    def get_library_path_for_symbol_win32(self, *args):
        """
        V.get_library_path_for_symbol_win32(void) -> string
        C++: static std::string GetLibraryPathForSymbolWin32(
            const void *fptr)
        Returns the name of the library providing the symbol. For
        example, if you want to locate where the VTK libraries located
        call `_get_library_path_for_symbol_unix("_get_vtk_version")` on Unixes and
        `_get_library_path_for_symbol_win32(_get_vtk_version)` on Windows.
        Alternatively, you can simply use the
        `vtk_get_library_path_for_symbol(_get_vtk_version)` macro that makes the
        appropriate call as per the current platform.
        """
        ret = self._wrap_call(self._vtk_obj.GetLibraryPathForSymbolWin32, *args)
        return ret

    def locate(self, *args):
        """
        V.locate(string, string, string) -> string
        C++: virtual std::string Locate(const std::string &anchor,
            const std::string &landmark,
            const std::string &defaultDir=std::string())
        V.locate(string, Stvector_ISt6stringE, string, string) -> string
        C++: virtual std::string Locate(const std::string &anchor,
            const std::vector<std::string> &landmark_prefixes,
            const std::string &landmark,
            const std::string &defaultDir=std::string())
        Given a starting anchor directory, look for the landmark file
        relative to the anchor. If found return the anchor. If not found,
        go one directory up and then look the landmark file again.
        """
        ret = self._wrap_call(self._vtk_obj.Locate, *args)
        return ret

    _updateable_traits_ = \
    (('print_debug_information', 'GetPrintDebugInformation'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'print_debug_information'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ResourceFileLocator, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ResourceFileLocator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['print_debug_information'], [], []),
            title='Edit ResourceFileLocator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ResourceFileLocator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

