package client;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.DataOutputStream;
import java.io.IOException;
import common.CommonConstants;

/**
 * キー入力を扱うスレッドです。
 * @author Kumano Tatsuo
 * Created on 2005/01/19 11:23:32
 */
public class KeyHandler extends Thread implements KeyListener {
    /**
     * プレイヤの向き
     * Created on 2005/01/28 13:51:37
     */
    public enum Direction {
        /**
         * 停止している状態
         */
        STOP,
        /**
         * 左を向いている状態
         */
        LEFT,
        /**
         * 右を向いている状態
         */
        RIGHT,
        /**
         * 上を向いている状態
         */
        UP,
        /**
         * 下を向いている状態
         */
        DOWN
    };

    /**
     * 1Pの出力ストリーム
     */
    private final DataOutputStream out1;

    /**
     * 2Pの出力ストリーム
     */
    private final DataOutputStream out2;

    /**
     * 爆弾キーが押されたかどうか
     */
    private boolean isBomb;

    /**
     * 1Pの向き
     */
    private Direction direction1;

    /**
     * 2Pの向き
     */
    private Direction direction2;

    /**
     * 1Pのキーが離される時刻 
     */
    private long releaseTime1;

    /**
     * 2Pのキーが離される時刻 
     */
    private long releaseTime2;

    /**
     * キー入力を扱うスレッドを初期化します。
     * @param out1 1Pの出力ストリーム
     * @param out2 2Pの出力ストリーム
     */
    public KeyHandler(final DataOutputStream out1, final DataOutputStream out2) {
        this.out1 = out1;
        this.out2 = out2;
        this.direction1 = Direction.STOP;
        this.direction2 = Direction.STOP;
        this.releaseTime1 = Long.MAX_VALUE;
        this.releaseTime2 = Long.MAX_VALUE;
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        try {
            switch (e.getKeyCode()) {
            case KeyEvent.VK_BACK_SLASH:
            case KeyEvent.VK_SPACE:
                this.isBomb = true;
                this.out1.writeByte(CommonConstants.COMMAND_BOMB_PRESSED);
                break;
            case KeyEvent.VK_Z:
                this.isBomb = true;
                this.out2.writeByte(CommonConstants.COMMAND_BOMB_PRESSED);
                break;
            case KeyEvent.VK_LEFT:
                if (this.direction1 != Direction.LEFT) {
                    this.direction1 = Direction.LEFT;
                    this.out1.writeByte(CommonConstants.COMMAND_LEFT_PRESSED);
                }
                this.releaseTime1 = Long.MAX_VALUE;
                break;
            case KeyEvent.VK_RIGHT:
                if (this.direction1 != Direction.RIGHT) {
                    this.direction1 = Direction.RIGHT;
                    this.out1.writeByte(CommonConstants.COMMAND_RIGHT_PRESSED);
                }
                this.releaseTime1 = Long.MAX_VALUE;
                break;
            case KeyEvent.VK_UP:
                if (this.direction1 != Direction.UP) {
                    this.direction1 = Direction.UP;
                    this.out1.writeByte(CommonConstants.COMMAND_UP_PRESSED);
                }
                this.releaseTime1 = Long.MAX_VALUE;
                break;
            case KeyEvent.VK_DOWN:
                if (this.direction1 != Direction.DOWN) {
                    this.direction1 = Direction.DOWN;
                    this.out1.writeByte(CommonConstants.COMMAND_DOWN_PRESSED);
                }
                this.releaseTime1 = Long.MAX_VALUE;
                break;
            case KeyEvent.VK_D:
                if (this.direction2 != Direction.LEFT) {
                    this.direction2 = Direction.LEFT;
                    this.out2.writeByte(CommonConstants.COMMAND_LEFT_PRESSED);
                }
                this.releaseTime2 = Long.MAX_VALUE;
                break;
            case KeyEvent.VK_G:
                if (this.direction2 != Direction.RIGHT) {
                    this.direction2 = Direction.RIGHT;
                    this.out2.writeByte(CommonConstants.COMMAND_RIGHT_PRESSED);
                }
                this.releaseTime2 = Long.MAX_VALUE;
                break;
            case KeyEvent.VK_R:
                if (this.direction2 != Direction.UP) {
                    this.direction2 = Direction.UP;
                    this.out2.writeByte(CommonConstants.COMMAND_UP_PRESSED);
                }
                this.releaseTime2 = Long.MAX_VALUE;
                break;
            case KeyEvent.VK_F:
                if (this.direction2 != Direction.DOWN) {
                    this.direction2 = Direction.DOWN;
                    this.out2.writeByte(CommonConstants.COMMAND_DOWN_PRESSED);
                }
                this.releaseTime2 = Long.MAX_VALUE;
                break;
            }
        } catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public void keyReleased(KeyEvent e) {
        switch (e.getKeyCode()) {
        case KeyEvent.VK_LEFT:
            if (this.direction1 == Direction.LEFT) {
                this.releaseTime1 = System.currentTimeMillis() + ClientConstants.KEY_RELEASE_TIME;
            }
            break;
        case KeyEvent.VK_RIGHT:
            if (this.direction1 == Direction.RIGHT) {
                this.releaseTime1 = System.currentTimeMillis() + ClientConstants.KEY_RELEASE_TIME;
            }
            break;
        case KeyEvent.VK_UP:
            if (this.direction1 == Direction.UP) {
                this.releaseTime1 = System.currentTimeMillis() + ClientConstants.KEY_RELEASE_TIME;
            }
            break;
        case KeyEvent.VK_DOWN:
            if (this.direction1 == Direction.DOWN) {
                this.releaseTime1 = System.currentTimeMillis() + ClientConstants.KEY_RELEASE_TIME;
            }
            break;
        case KeyEvent.VK_D:
            if (this.direction2 == Direction.LEFT) {
                this.releaseTime2 = System.currentTimeMillis() + ClientConstants.KEY_RELEASE_TIME;
            }
            break;
        case KeyEvent.VK_G:
            if (this.direction2 == Direction.RIGHT) {
                this.releaseTime2 = System.currentTimeMillis() + ClientConstants.KEY_RELEASE_TIME;
            }
            break;
        case KeyEvent.VK_R:
            if (this.direction2 == Direction.UP) {
                this.releaseTime2 = System.currentTimeMillis() + ClientConstants.KEY_RELEASE_TIME;
            }
            break;
        case KeyEvent.VK_F:
            if (this.direction2 == Direction.DOWN) {
                this.releaseTime2 = System.currentTimeMillis() + ClientConstants.KEY_RELEASE_TIME;
            }
            break;
        }
    }

    public void run() {
        while (true) {
            try {
                if (System.currentTimeMillis() >= this.releaseTime1) {
                    if (this.direction1 != Direction.STOP) {
                        this.releaseTime1 = Long.MAX_VALUE;
                        this.direction1 = Direction.STOP;
                        this.out1.writeByte(CommonConstants.COMMAND_KEY_RELEASED);
                    }
                }
                if (System.currentTimeMillis() >= this.releaseTime2) {
                    if (this.direction2 != Direction.STOP) {
                        this.releaseTime2 = Long.MAX_VALUE;
                        this.direction2 = Direction.STOP;
                        this.out2.writeByte(CommonConstants.COMMAND_KEY_RELEASED);
                    }
                }
                Thread.sleep(ClientConstants.KEY_HANDLER_THREAD_WAIT_TIME);
            } catch (InterruptedException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * @return 爆弾キーが押されたかどうか
     */
    public boolean isBomb() {
        boolean ret = this.isBomb;
        this.isBomb = false;
        return ret;
    }
}
