
import java.awt.FlowLayout;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import javax.swing.JFrame;
import javax.swing.WindowConstants;
import client.ClientConstants;
import client.Game;
import client.KeyHandler;
import client.LoginDialog;
import client.SubPanel;
import client.MainPanel;
import common.CommonConstants;

/**
 * クライアントのメインクラスです。
 * @author Kumano Tatsuo
 * Created on 2005/01/18 22:14:09
 */
public class Client {
    /**
     * メインメソッドです。
     * @param args コマンドライン引数
     */
    public static void main(String[] args) {
        try {
            final String host = "zenjiro.dyndns.org";
            final Socket socket1 = new Socket(host, CommonConstants.CONNECTION_PORT);
            final DataInputStream in1 = new DataInputStream(socket1.getInputStream());
            final DataOutputStream out1 = new DataOutputStream(socket1.getOutputStream());
            final Socket socket2 = new Socket(host, CommonConstants.CONNECTION_PORT);
            final DataInputStream in2 = new DataInputStream(socket2.getInputStream());
            final DataOutputStream out2 = new DataOutputStream(socket2.getOutputStream());
            final Game game = new Game(in1, in2);
            game.start();
            final JFrame frame = new JFrame("Bomb");
            final KeyHandler handler = new KeyHandler(out1, out2);
            handler.start();
            final MainPanel mainPanel = new MainPanel(in1, out1, in2, out2, handler, game);
            final SubPanel subPanel = new SubPanel(game);
            new Thread(subPanel).start();
            frame.setLayout(new FlowLayout(FlowLayout.CENTER, 0, 0));
            frame.add(mainPanel);
            frame.add(subPanel);
            frame.pack();
            frame.addKeyListener(handler);
            frame.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
            frame.setVisible(true);
            new Thread(mainPanel).start();
            LoginDialog loginDialog = new LoginDialog(frame, "Bomb", true, out1, out2);
            while (!loginDialog.isOK()) {
                while (!handler.isBomb()) {
                    Thread.sleep(ClientConstants.KEY_HANDLER_THREAD_WAIT_TIME);
                }
                loginDialog.setVisible(true);
                Thread.sleep(1000);
            }
        } catch (IOException e) {
            System.err.println("サーバが起動していないようです。");
            System.err.println("しばらくしてから、アプリケーションを再起動してみてください。");
        } catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }
}
