import java.awt.event.*;
import java.util.*;

/*
 * : 2004/01/19
 */

/**
 * Ͽޤɤ߹ߡݥꥴη硢ɤʬ°ְ֤η׻ʤɡ
 * Хå饦ɤǹԤȤ륯饹Ǥ
 * @author Kumano Tatsuo
 */
class BackgroundThread extends Thread {

	private Map maps; // Ͽ
	private MapPanel panel; // ѥͥ
	private boolean isChanged; // Ͽޤξ֤Ѳɤ

	BackgroundThread(Map maps, MapPanel panel) {
		this.maps = maps;
		this.panel = panel;
		isChanged = false;

		panel.addMouseListener(new MouseAdapter() {
			public void mouseReleased(MouseEvent e) {
				isChanged = true;
			}
		});
		panel.addMouseWheelListener(new MouseWheelListener() {
			public void mouseWheelMoved(MouseWheelEvent e) {
				isChanged = true;
			}
		});
		panel.addComponentListener(new ComponentAdapter() {
			public void componentResized(ComponentEvent e) {
				isChanged = true;
			}
		});

	}

	public void run() {
		try {
			while (true) {
				if (panel.isIdle() && isChanged) {
					loadMapPaintTyomeJoinTyome();
					isChanged = false;
				}
				Thread.sleep(200);
			}
		} catch (InterruptedException e) {
			e.printStackTrace(System.err);
		}
	}

	void loadMapPaintTyomeJoinTyome() {
		try {
			long startTime = System.currentTimeMillis();
			LoadMap loadMap = new LoadMap();
			loadMap.loadMap(maps, (MapPanel) panel);
			if (System.currentTimeMillis() - startTime > 200) {
				System.out.println("Ͽޤɤ߹ߡ" + (System.currentTimeMillis() - startTime) + " ms");
			}
			startTime = System.currentTimeMillis();
			PaintTyome paintTyome = new PaintTyome();
			paintTyome.paintTyome(maps);
			if (System.currentTimeMillis() - startTime > 200) {
				System.out.println("ɤʬ" + (System.currentTimeMillis() - startTime) + " ms");
			}
			startTime = System.currentTimeMillis();
			JoinPolygon joinTyome = new JoinPolygon();
			joinTyome.joinPolygon(maps);
			JoinTatemono joinTatemono = new JoinTatemono();
			joinTatemono.joinTatemono(maps);
			if (System.currentTimeMillis() - startTime > 200) {
				System.out.println("ݥꥴη硧" + (System.currentTimeMillis() - startTime) + " ms");
			}
			startTime = System.currentTimeMillis();
			FixAttributeLocation fixAttributeLocation = new FixAttributeLocation();
			fixAttributeLocation.fixAttributeLocation(maps, (MapPanel) panel);
			if (System.currentTimeMillis() - startTime > 200) {
				System.out.println("°֤η׻" + (System.currentTimeMillis() - startTime) + " ms");
			}
			panel.setNeedsRepaint(true);
			panel.repaint();
		} catch (Exception exception) {
			System.err.println("Failed to load map.");
			exception.printStackTrace(System.err);
		}
	}

}
