import java.io.*;
import java.util.*;
import java.util.regex.*;

/*
 * Main.java
 *
 * Created on 2003/11/13, 18:18
 */

/**
 *
 * @author  kumano
 */
public class Main {

	private static MapFrame frame;
	private static Map maps;

	/**
	 * @param args the command line arguments
	 */
	public static void main(String[] args) throws Exception {
		maps = new HashMap();

		frame = new MapFrame();
		frame.show();
		MapPanel panel = (MapPanel) frame.shapePanel;

		System.out.println("Loading map infomation...");
		String baseDir = "data";
		String files[] = new File(baseDir).list();
		Pattern pattern = Pattern.compile("[0-9][0-9][a-zA-Z][a-zA-Z][0-9][0-9][0-9]");
		for (int i = 0; i < files.length; i++) {
			if (pattern.matcher(files[i]).matches()) {
				String mapName = files[i].toLowerCase();
				//System.out.println("loading " + mapName + "... [" + (int) ((i + 1) * 100.0 / files.length) + "%]");
				maps.put(mapName, new MapData(baseDir, mapName));
			}
		}
		System.out.println("Map information loading finished.");

		panel.setMapData(maps);
		panel.zoomAutomaticaly();
		panel.moveToCenter();
		panel.repaint();

		Thread loadMapThread = new LoadMapThread(maps, panel);
		loadMapThread.start();
	}
}
