import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.util.*;
import javax.swing.JPanel;
/**
 * Shape ֥Ȥե졼褹륯饹Ǥ
 */
public class ShapePanel extends JPanel {
	private Collection data;
	private boolean isZoomChanged; // Ψѹ줿ɤ
	private double lastHeight; // ľι⤵
	private double lastMouseX; // ľΥޥɸ
	private double lastMouseY; // ľΥޥɸ
	private double lastWidth; // ľ
	private MapListener mapListener = null;
	private double maxX;
	private double maxY;
	private double minX;
	private double minY;
	private double offsetX; // եå(ºɸ)
	private double offsetY; // եå(ºɸ)
	private String title = "";
	private double zoom; // ɽΨ
	/**
	 * 󥹥ȥ饯Ǥ
	 * ե졼Υꤷޤ
	 */
	public ShapePanel() {
		setBackground(Color.white);
		offsetX = 0;
		offsetY = 0;
		zoom = 1;
		isZoomChanged = true;
		lastMouseX = offsetX;
		lastMouseY = offsetY;
		lastWidth = getWidth();
		lastHeight = getHeight();
		addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				lastMouseX = e.getX();
				lastMouseY = e.getY();
			}
		});
		addMouseMotionListener(new MouseMotionAdapter() {
			public void mouseDragged(MouseEvent e) {
				offsetX -= e.getX() - lastMouseX;
				offsetY -= e.getY() - lastMouseY;
				lastMouseX = e.getX();
				lastMouseY = e.getY();
				repaint();
				if (mapListener != null) {
					mapListener.mapMoved(new MapEvent(this));
				}
			}
		});
		addMouseWheelListener(new MouseWheelListener() {
			public void mouseWheelMoved(MouseWheelEvent e) {
				double newZoom = zoom * (1 + (double)e.getWheelRotation() / 20);
				double newX = (offsetX + e.getX()) / zoom * newZoom - e.getX();
				double newY = (offsetY + e.getY()) / zoom * newZoom - e.getY();
				offsetX = newX;
				offsetY = newY;
				zoom = newZoom;
				isZoomChanged = true;
				repaint();
				if (mapListener != null) {
					mapListener.mapZoomChanged(new MapEvent(this));
				}
			}
		});
		addComponentListener(new ComponentAdapter() {
			public void componentResized(ComponentEvent e) {
				double newZoomX = zoom * getWidth() / lastWidth;
				double newZoomY = zoom * getHeight() / lastHeight;
				double newZoom = Math.sqrt(newZoomX * newZoomY);
				double newOffsetX = offsetX * newZoom / zoom;
				double newOffsetY = offsetY * newZoom / zoom;
				lastWidth = getWidth();
				lastHeight = getHeight();
				offsetX = newOffsetX;
				offsetY = newOffsetY;
				zoom = newZoom;
				isZoomChanged = true;
				if (mapListener != null) {
					mapListener.mapZoomChanged(new MapEvent(this));
				}
			}
		});
	}
	/**
	 * Υե졼फ桼٥Ȥ뤿ˡꤵ줿ޥåץꥹʤɲäޤ
	 * l  null ξ硢㳰ϥ줺¹Ԥޤ
	 * @param l ޥåץꥹ
	 */
	public void addMapListener(MapListener l) {
		mapListener = l;
	}
	/**
	 * Shape ֥ȤΥǡޤ
	 * @return Shape ֥ȤΥǡ 
	 */
	public Collection getData() {
		return data;
	}
	/**
	 * @return
	 */
	public double getMaxX() {
		return maxX;
	}
	/**
	 * @return
	 */
	public double getMaxY() {
		return maxY;
	}
	/**
	 * @return
	 */
	public double getMinX() {
		return minX;
	}
	/**
	 * @return
	 */
	public double getMinY() {
		return minY;
	}
	/**
	 * ֥Ȥ¸ߤϰϤޤ
	 * @return ֥Ȥ¸ߤϰ
	 */
	public Rectangle2D getObjectArea() {
		return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
	}
	/**
	 * ɽƤϰϤޤ
	 * @return ɽƤϰ
	 */
	public Rectangle2D getVisibleArea() {
		return new Rectangle2D.Double(offsetX / zoom, offsetY / zoom, getWidth() / zoom, getHeight() / zoom);
	}
	/**
	 * Ψޤ
	 * @return Ψ
	 */
	public double getZoom() {
		return zoom;
	}
	/**
	 * ꤷ֥Ȥɽꥢˤ뤫ɤޤ
	 * @param shape ֥
	 * @return ꤷ֥Ȥɽꥢˤ뤫ɤ
	 */
	public boolean isVisible(Shape shape) {
		return shape.intersects(getVisibleArea());
	}
	/**
	 * Ψѹ줿ɤޤ
	 * @return Ψѹ줿ɤ
	 */
	public boolean isZoomChanged() {
		if (isZoomChanged) {
			isZoomChanged = false;
			return true;
		} else {
			return false;
		}
	}
	/**
	 * ե졼ब褵˸ƤӽФޤ
	 */
	public void paint(Graphics g) {
		Image image = createImage(getWidth(), getHeight());
		Graphics2D g2 = (Graphics2D)image.getGraphics();
		//g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		g2.setColor(Color.WHITE);
		g2.fillRect(0, 0, getWidth(), getHeight());
		g2.setColor(Color.BLACK);
		g2.drawString(title, 20, 40);
		g2.translate(-offsetX, -offsetY);
		g2.scale(zoom, zoom);
		double x = offsetX / zoom;
		double y = offsetY / zoom;
		double w = getWidth() / zoom;
		double h = getHeight() / zoom;
		double alpha = 1;
		if (data != null) {
			Iterator iterator = data.iterator();
			// ֥Ȥ褹
			while (iterator.hasNext()) {
				Object o = iterator.next();
				boolean isDrawable = false;
				try {
					Drawable dummy = (Drawable)o;
					isDrawable = true;
				} catch (ClassCastException e) {
				}
				if (((Shape)o).intersects(x, y, w, h)) {
					if (isDrawable) {
						if (((Drawable)o).getFillColor() != null) {
							g2.setColor(((Drawable)o).getFillColor());
							if (((Drawable)o).getAlpha() != alpha) {
								alpha = ((Drawable)o).getAlpha();
								AlphaComposite ac =
									AlphaComposite.getInstance(AlphaComposite.SRC_OVER, (float)alpha);
								g2.setComposite(ac);
							}
							g2.fill((Shape)o);
						}
					} else {
						g2.setColor(Color.BLACK);
						g2.fill((Shape)o);
					}
					if (isDrawable) {
						if (((Drawable)o).getBorderColor() != null) {
							g2.setColor(((Drawable)o).getBorderColor());
							g2.draw((Shape)o);
						}
					} else {
						g2.setColor(Color.BLACK);
						g2.draw((Shape)o);
					}
				}
			}
			// ݥꥴξ硢褹
			iterator = data.iterator();
			while (iterator.hasNext()) {
				Object o = iterator.next();
				boolean isDrawablePolygon = false;
				try {
					DrawablePolygon dummy = (DrawablePolygon)o;
					isDrawablePolygon = true;
				} catch (ClassCastException e) {
				}
				if (isDrawablePolygon) {
					if (((DrawablePolygon)o).getPointColor() != null) {
						if (((DrawablePolygon)o).getLocation() != null) {
							if (((DrawablePolygon)o).getFont() != null) {
								if (((DrawablePolygon)o).getLabel().length() > 0) {
									if (((DrawablePolygon)o).getStatus() != DrawablePolygon.STATUS_SUB) {
										DrawablePoint point =
											new DrawablePoint(
												((DrawablePolygon)o).getX(),
												((DrawablePolygon)o).getY());
										point.setSize(((DrawablePolygon)o).getPointSize());
										g2.setColor(((DrawablePolygon)o).getPointColor());
										g2.fill(point);
									}
								}
							}
						}
					}
				}
			}
			// ٥褹
			iterator = data.iterator();
			while (iterator.hasNext()) {
				Object o = iterator.next();
				boolean isDrawable = false;
				try {
					Drawable dummy = (Drawable)o;
					isDrawable = true;
				} catch (ClassCastException e) {
				}
				if (isDrawable) {
					if (((Drawable)o).getLabel() != null
						&& ((Drawable)o).getLabelLocation() != null
						&& ((Drawable)o).getFont() != null) {
						FontMetrics metrics = getFontMetrics(((Drawable)o).getFont());
						Rectangle2D label =
							new Rectangle2D.Double(
								((Drawable)o).getLabelLocation().getX(),
								((Drawable)o).getLabelLocation().getY(),
								metrics.stringWidth(((Drawable)o).getLabel()),
								metrics.getAscent());
						if (label.intersects(x, y, w, h)) {
							g2.setColor(Color.BLACK);
							if (((Drawable)o).getFont() != null) {
								g2.setFont(((Drawable)o).getFont());
							}
							g2.drawString(
								((Drawable)o).getLabel(),
								(int) ((Drawable)o).getLabelLocation().getX(),
								(int) ((Drawable)o).getLabelLocation().getY());
						}
					}
				}
			}
			g.drawImage(image, 0, 0, this);
		}
	}
	/**
	 * Shape ֥ȤΥǡꤷޤ
	 * @param data ǡ
	 */
	public void resetData(Collection data) {
		this.data = data;
	}
	/**
	 * Shape ֥ȤΥǡꤷޤ
	 * @param data ǡ
	 */
	public void setData(Collection data) {
		this.data = data;
		minX = Double.MAX_VALUE;
		minY = Double.MAX_VALUE;
		maxX = Double.MIN_VALUE;
		maxY = Double.MIN_VALUE;
		Iterator iterator = data.iterator();
		while (iterator.hasNext()) {
			Object object = iterator.next();
			Rectangle2D bounds = ((Shape)object).getBounds2D();
			if (bounds.getX() < minX) {
				minX = bounds.getX();
			}
			if (bounds.getY() < minY) {
				minY = bounds.getY();
			}
			if (maxX < bounds.getX() + bounds.getWidth()) {
				maxX = bounds.getX() + bounds.getWidth();
			}
			if (maxY < bounds.getY() + bounds.getHeight()) {
				maxY = bounds.getY() + bounds.getHeight();
			}
		}
		double zoomX = getWidth() / (maxX - minX);
		double zoomY = getHeight() / (maxY - minY);
		/*
		// ̤äѤɽ
		if (zoomY < zoomX) {
			zoom = zoomY;
		} else {
			zoom = zoomX;
		}
		*/
		zoom = 0.2;
		isZoomChanged = true;
		offsetX = (minX + maxX) / 2 * zoom - getWidth() / 2;
		offsetY = (minY + maxY) / 2 * zoom - getHeight() / 2;
		if (mapListener != null) {
			mapListener.mapZoomChanged(new MapEvent(this));
		}
	}
	/**
	 * ȥꤷޤ
	 * @param title ȥ
	 */
	public void setTitle(String title) {
		this.title = title;
	}
	/**
	 * ۺɸޤ
	 * @param location ºɸ
	 * @return ۺɸ
	 */
	public Point2D toVirtualLocation(Point2D location) {
		return new Point2D.Double((offsetX + location.getX()) / zoom, (offsetY + location.getY()) / zoom);
	}
}
