import java.awt.*;
import java.awt.geom.Point2D;
import java.io.*;
import java.util.*;
/**
 * ΡֿϿ2500ʶ֥ǡסˡפɤ߹९饹Ǥ
 */
public class LoadMap {
	/**
	 * ƥѤΥ᥽åɤǤ
	 * @param arg ޥɥ饤
	 */
	public static void main(String[] args) {
		String baseDir = "../map_data/suchi_chizu_2500/";
		LoadMap loadMap = new LoadMap();
		String files[] = loadMap.getDirList(baseDir);
		for (int i = 0; i < files.length; i++) {
			String arcFile = baseDir + files[i] + "/gyousei/gyousei.arc";
			String polygonFile = baseDir + files[i] + "/gyousei/tyome.pgn";
			String attributeFile = baseDir + files[i] + "/gyousei/tyome.atr";
			loadMap.loadArc(arcFile);
			loadMap.loadPolygon(polygonFile, 0, null, null, Color.RED, 20);
			loadMap.loadAttribute(attributeFile);
		}
		loadMap.joinPolygons();
		loadMap.arrangeLabels();
		// ɽ
		MapFrame frame = new MapFrame();
		frame.show();
		ShapePanel panel = (ShapePanel)frame.shapePanel;
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e1) {
			e1.printStackTrace();
		}
		panel.setData(loadMap.getData());
		panel.repaint();
	}
	private Map arcs;
	private Map attributes;
	private Set data;
	private Map joinablePolygons;
	private Map polygons;
	/**
	 *  LoadMap ֥Ȥޤ 
	 */
	public LoadMap() {
		arcs = new HashMap();
		polygons = new HashMap();
		attributes = new HashMap();
		joinablePolygons = new HashMap();
		data = new TreeSet();
	}
	/**
	 * ɽѤΥǡ˿դ٥ꤷޤ 
	 */
	public void arrangeLabels() {
		Set keys = polygons.keySet();
		Iterator iterator = keys.iterator();
		Font font = new Font("Arial", Font.PLAIN, 50);
		while (iterator.hasNext()) {
			Object key = iterator.next();
			DrawablePolygon polygon = (DrawablePolygon)polygons.get(key);
			Set label = (Set)attributes.get(key);
			if (label != null) {
				Iterator labelIterator = label.iterator();
				if (label.size() > 1) {
					Object dummy = labelIterator.next();
					String labelString = (String)labelIterator.next();
					if (polygon.getStatus() != DrawablePolygon.STATUS_SUB) {
						polygon.setLabel(labelString);
					}
				}
			}
			if (polygon.getStatus() == DrawablePolygon.STATUS_NORMAL) {
				double x = ((Shape)polygon).getBounds2D().getCenterX();
				double y = ((Shape)polygon).getBounds2D().getCenterY();
				DrawablePoint point = new DrawablePoint(x, y);
				polygon.setLabelLocation(point);
				polygon.setLocation(point);
			}
			polygon.setFont(font);
			data.add(polygon);
		}
	}
	/**
	 * ɽѤΥǡޤ
	 * @return ɽѤΥǡ
	 */
	public Set getData() {
		return data;
	}
	/**
	 * ꤷǥ쥯ȥ˴ޤޤեΰޤ
	 * @param dir ɽǥ쥯ȥ
	 * @return ꤷǥ쥯ȥ˴ޤޤեΰ
	 */
	public String[] getDirList(String dir) {
		return new File(dir).list();
	}
	/**
	 * ɤ߹ݥꥴǡޤ
	 * @return ɤ߹ݥꥴǡ
	 */
	public Map getPolygons() {
		return polygons;
	}
	/**
	 * ꤷե뤬¸ߤ뤫ɤޤ
	 * @param file ¸ߤ뤫ɤĴ٤ե
	 * @return ꤷե뤬¸ߤ뤫ɤ
	 */
	public boolean isExists(String file) {
		return new File(file).exists();
	}
	/**
	 * ɤ߹ݥꥴΤǤʬ礷ޤ
	 */
	public void joinPolygons() {
		RandomColor randomColor = new RandomColor();
		// ݥꥴηطĴ٤
		Map joiningPolygons = new LinkedHashMap();
		Set keys = joinablePolygons.keySet();
		Iterator iterator = keys.iterator();
		while (iterator.hasNext()) {
			Object key = iterator.next();
			Set values = (Set)joinablePolygons.get(key);
			if ((values).size() > 1) {
				Iterator iterator2 = values.iterator();
				Object polygon1 = iterator2.next();
				Object polygon2 = iterator2.next();
				if (joiningPolygons.containsKey(polygon1)) {
					Set set = (Set)joiningPolygons.get(polygon1);
					set.add(polygon2);
				} else {
					Set set = new LinkedHashSet();
					set.add(polygon2);
					joiningPolygons.put(polygon1, set);
				}
				if (joiningPolygons.containsKey(polygon2)) {
					Set set = (Set)joiningPolygons.get(polygon2);
					set.add(polygon1);
				} else {
					Set set = new LinkedHashSet();
					set.add(polygon1);
					joiningPolygons.put(polygon2, set);
				}
			}
		}
		// ݥꥴޤȤ
		Set finalPolygons = new HashSet();
		keys = joiningPolygons.keySet();
		iterator = keys.iterator();
		while (iterator.hasNext()) {
			Object key = iterator.next();
			Set values = (Set)joiningPolygons.get(key);
			// key õ
			Iterator iterator2 = finalPolygons.iterator();
			boolean isKeyFound = false;
			while (iterator2.hasNext()) {
				Set set = (Set)iterator2.next();
				if (set.contains(key)) {
					set.addAll(values);
					isKeyFound = true;
				}
			}
			if (!isKeyFound) {
				Set set = new LinkedHashSet();
				set.add(key);
				set.addAll(values);
				finalPolygons.add(set);
			}
		}
		keys = polygons.keySet();
		iterator = keys.iterator();
		while (iterator.hasNext()) {
			Object key = iterator.next();
			DrawablePolygon p = (DrawablePolygon)polygons.get(key);
			if (p.getFillColor() == null) {
				p.setFillColor(randomColor.getRandomColor());
			}
		}
		// ݥꥴθܤƱˤ
		// Хꡢzyouti ɤ߹ sityo οˤʤäƤޤ
		iterator = finalPolygons.iterator();
		while (iterator.hasNext()) {
			Set set = (Set)iterator.next();
			Iterator iterator2 = set.iterator();
			Color color = null;
			DrawablePolygon polygon = new DrawablePolygon(); // ߤ BoundingBox 
			DrawablePolygon mainPolygon = null;
			DrawablePolygon subPolygon;
			if (iterator2.hasNext()) {
				mainPolygon = (DrawablePolygon)polygons.get(iterator2.next());
				if (mainPolygon != null) {
					mainPolygon.setStatus(DrawablePolygon.STATUS_MAIN);
					color = mainPolygon.getFillColor();
					for (int i = 0; i < mainPolygon.npoints; i++) {
						polygon.addPoint(mainPolygon.xpoints[i], mainPolygon.ypoints[i]);
					}
				}
			}
			while (iterator2.hasNext()) {
				subPolygon = (DrawablePolygon)polygons.get(iterator2.next());
				if (subPolygon != null) {
					subPolygon.setFillColor(color);
					for (int i = 0; i < subPolygon.npoints; i++) {
						polygon.addPoint(subPolygon.xpoints[i], subPolygon.ypoints[i]);
					}
					subPolygon.setStatus(DrawablePolygon.STATUS_SUB);
				}
			}
			if (mainPolygon != null) {
				DrawablePoint point =
					new DrawablePoint(polygon.getBounds2D().getCenterX(), polygon.getBounds2D().getCenterY());
				mainPolygon.setLabelLocation((Point2D)point);
				mainPolygon.setLocation((Point2D)point);
				//  polygon ȤɲäΤɤĤ֤ʤ
			}
		}
	}
	/**
	 * ե뤫̾ɤ߹ߤޤ
	 * @param file ե
	 */
	public void loadArc(String file) {
		Map arcs = new HashMap();
		try {
			BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
			String line;
			double x1 = 0; // ޳Ժ x ɸ
			double y1 = 0; // ޳Ժ y ɸ
			DrawableArc arc = new DrawableArc();
			String figureName = null;
			String diagramTypeCode = null;
			String arcIndex = null;
			int lineTypeTag = 0;
			while ((line = in.readLine()) != null) {
				//System.out.println("line = " + line);
				if (line.length() > 1 && line.subSequence(0, 2).equals("FH")) {
					// եإå쥳
					StringTokenizer token = new StringTokenizer(line, ",");
					int tokenNumber = token.countTokens();
					String dummy = token.nextToken(); // FH
					figureName = token.nextToken(); // ̾
					String fileName = token.nextToken(); // ե̾
					String recordNumber = token.nextToken(); // 쥳
					String elementNumber = token.nextToken(); // Ǥ
					dummy = token.nextToken(); // ɸϥե饰
					dummy = token.nextToken(); // ɸֹ
					if (tokenNumber == 16) {
						dummy = token.nextToken(); // Ͳʬ
					}
					y1 = Double.parseDouble(token.nextToken());
					x1 = Double.parseDouble(token.nextToken());
				} else if (line.substring(0, 1).equals("L")) {
					//  ID 쥳
					if (arcIndex != null && arc != null) {
						if (lineTypeTag == 5) {
							arc.setIncomplete(true);
						}
						arcs.put(figureName + "_" + arcIndex, arc);
						arc = new DrawableArc();
					}
					StringTokenizer token = new StringTokenizer(line, ",");
					diagramTypeCode = token.nextToken(); // ޼ʬॳ
					lineTypeTag = Integer.parseInt(token.nextToken()); // 勵
					arcIndex = token.nextToken(); // ֹ
					String recordNumber = token.nextToken(); // 쥳ɤο
				} else {
					// ɸ
					StringTokenizer token = new StringTokenizer(line, ",");
					double y = Double.parseDouble(token.nextToken()) + y1;
					// y ɸ
					double x = Double.parseDouble(token.nextToken()) + x1;
					// x ɸ
					//x /= 10;
					//y /= 10;
					y *= -1;
					//x -= 8000;
					//y -= 13200;
					//System.out.println("(" + x + ", " + y + ")");
					arc.addPoint((int)x, (int)y);
				}
				if (arcIndex != null && arc != null) {
					if (lineTypeTag == 5) {
						arc.setIncomplete(true);
					}
					arcs.put(figureName + "_" + arcIndex, arc);
				}
			}
		} catch (IOException e) {
		}
		this.arcs.putAll(arcs);
	}
	/**
	 * Ͽޥե뤫°ɤ߹ǡֿ̾,޼ʬॳ,ֹפ򥭡°ͤȤ Map ֤ޤ
	 * @param file ե̾
	 * @return ֿ̾,޼ʬॳ,ֹפ򥭡°ͤȤ Map
	 */
	public void loadAttribute(String file) {
		Map attributes = new HashMap();
		try {
			BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file), "SJIS"));
			String line;
			String figureName = null;
			while ((line = in.readLine()) != null) {
				if (line.length() > 1 && line.subSequence(0, 2).equals("FH")) {
					// եإå쥳
					StringTokenizer token = new StringTokenizer(line, ",");
					String dummy = token.nextToken(); // FH
					figureName = token.nextToken(); // ̾
				} else {
					// °쥳
					StringTokenizer token = new StringTokenizer(line, ",");
					String diagramTypeCode = token.nextToken(); // ޼ʬॳ
					String targetIndex = token.nextToken(); // ֹ
					String dummy = token.nextToken(); // °
					Set attribute = new LinkedHashSet(); // °
					while (token.hasMoreTokens()) {
						attribute.add(token.nextToken()); // °15
					}
					attributes.put(figureName + "_" + diagramTypeCode + "_" + targetIndex, attribute);
				}
			}
		} catch (IOException e) {
		}
		this.attributes.putAll(attributes);
	}
	/**
	 * Ͽޥǡݥꥴɤ߹ߤޤ
	 * fillColor  null ΤȤݥꥴϥʿɤĤ֤ޤ
	 * borderColor  null ΤȤݥꥴسԤɽޤ
	 * pointColor  null ΤȤݥꥴɽɽޤ 
	 * @param file ե̾
	 * @param zOrder ɽν
	 * @param fillColor ɤĤ֤
	 * @param borderColor سο
	 * @param ɽɽο
	 * @param ɽɽ礭
	 */
	public void loadPolygon(
		String file,
		int zOrder,
		Color fillColor,
		Color borderColor,
		Color pointColor,
		double pointSize) {
		Map polygons = new HashMap();
		try {
			BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
			String line;
			String figureName = null;
			String diagramTypeCode = null;
			String polygonIndex = null;
			DrawablePolygon polygon = null;
			Point2D labelLocation = new Point2D.Double();
			double figureX1 = 0; // ޳Ժ x ɸ
			double figureY1 = 0; // ޳Ժ y ɸ
			while ((line = in.readLine()) != null) {
				//System.out.println("line = " + line);
				if (line.length() > 1 && line.subSequence(0, 2).equals("FH")) {
					// եإå쥳
					StringTokenizer token = new StringTokenizer(line, ",");
					int tokenNumber = token.countTokens();
					String dummy = token.nextToken(); // FH
					figureName = token.nextToken(); // ̾
					String fileName = token.nextToken(); // ե̾
					String recordNumber = token.nextToken(); // 쥳
					String elementNumber = token.nextToken(); // Ǥ
					dummy = token.nextToken(); // ɸϥե饰
					dummy = token.nextToken(); // ɸֹ
					if (tokenNumber == 16) {
						dummy = token.nextToken(); // Ͳʬ
					}
					figureY1 = Double.parseDouble(token.nextToken());
					figureX1 = Double.parseDouble(token.nextToken());
				} else if (line.substring(0, 1).equals("A")) {
					// ݥꥴ ID 쥳
					if (polygon != null) {
						polygon.setZOrder(zOrder);
						polygons.put(figureName + "_" + diagramTypeCode + "_" + polygonIndex, polygon);
						polygon = null;
					}
					StringTokenizer token = new StringTokenizer(line, ",");
					diagramTypeCode = token.nextToken(); // ޼ʬॳ
					polygonIndex = token.nextToken(); // ֹ
					String dummy = token.nextToken(); // 쥳ɤο
					// ɽκɸ
					double y = Double.parseDouble(token.nextToken()) + figureY1;
					double x = Double.parseDouble(token.nextToken()) + figureX1;
					y *= -1;
				} else {
					// 쥳
					StringTokenizer token = new StringTokenizer(line, ",");
					long arcIndex = Long.parseLong(token.nextToken());
					String arcIndexAbs = Long.toString(Math.abs(arcIndex));
					boolean isReverse = (arcIndex < 0) ? true : false;
					DrawableArc arc = (DrawableArc)arcs.get(figureName + "_" + arcIndexAbs);
					int[] arcX = new int[arc.npoints];
					int[] arcY = new int[arc.npoints];
					if (!isReverse) {
						for (int i = 0; i < arc.npoints; i++) {
							arcX[i] = arc.xpoints[i];
							arcY[i] = arc.ypoints[i];
						}
					} else {
						for (int i = 0; i < arc.npoints; i++) {
							arcX[i] = arc.xpoints[arc.npoints - i - 1];
							arcY[i] = arc.ypoints[arc.npoints - i - 1];
						}
					}
					if (arc != null) {
						if (polygon == null) {
							polygon = new DrawablePolygon();
							polygon.setFillColor(fillColor);
							polygon.setBorderColor(borderColor);
							polygon.setPointColor(pointColor);
							polygon.setPointSize(pointSize);
							polygon.npoints = arcX.length;
							polygon.xpoints = new int[arcX.length];
							polygon.ypoints = new int[arcX.length];
							for (int i = 0; i < arc.npoints; i++) {
								polygon.xpoints[i] = arcX[i];
								polygon.ypoints[i] = arcY[i];
							}
						} else {
							int[] x = new int[polygon.npoints + arcX.length];
							int[] y = new int[polygon.npoints + arcY.length];
							for (int i = 0; i < polygon.npoints; i++) {
								x[i] = polygon.xpoints[i];
								y[i] = polygon.ypoints[i];
							}
							for (int i = 0; i < arcX.length; i++) {
								x[polygon.npoints + i] = arcX[i];
								y[polygon.npoints + i] = arcY[i];
							}
							polygon.npoints = x.length;
							polygon.xpoints = new int[x.length];
							polygon.ypoints = new int[y.length];
							for (int i = 0; i < x.length; i++) {
								polygon.xpoints[i] = x[i];
								polygon.ypoints[i] = y[i];
							}
						}
						if (arc.isIncomplete()) {
							polygon.setIncomplete(true);
							int x1 = arc.xpoints[0];
							int y1 = arc.ypoints[0];
							int x2 = arc.xpoints[1];
							int y2 = arc.ypoints[1];
							String borderLine;
							if (x1 + y1 < x2 + y2) {
								borderLine = x1 + "_" + y1 + "_" + x2 + "_" + y2;
							} else {
								borderLine = x2 + "_" + y2 + "_" + x1 + "_" + y1;
							}
							if (joinablePolygons.containsKey(borderLine)) {
								Set set = (Set)joinablePolygons.get(borderLine);
								set.add(figureName + "_" + diagramTypeCode + "_" + polygonIndex);
							} else {
								Set set = new HashSet();
								set.add(figureName + "_" + diagramTypeCode + "_" + polygonIndex);
								joinablePolygons.put(borderLine, set);
							}
							// Ѥ˴ʰб
							if (arc.npoints > 2) {
								x1 = arc.xpoints[1];
								y1 = arc.ypoints[1];
								x2 = arc.xpoints[2];
								y2 = arc.ypoints[2];
								if (x1 + y1 < x2 + y2) {
									borderLine = x1 + "_" + y1 + "_" + x2 + "_" + y2;
								} else {
									borderLine = x2 + "_" + y2 + "_" + x1 + "_" + y1;
								}
								if (joinablePolygons.containsKey(borderLine)) {
									Set set = (Set)joinablePolygons.get(borderLine);
									set.add(figureName + "_" + diagramTypeCode + "_" + polygonIndex);
								} else {
									Set set = new HashSet();
									set.add(figureName + "_" + diagramTypeCode + "_" + polygonIndex);
									joinablePolygons.put(borderLine, set);
								}
							}
							if (arc.npoints > 3) {
								x1 = arc.xpoints[2];
								y1 = arc.ypoints[2];
								x2 = arc.xpoints[3];
								y2 = arc.ypoints[3];
								if (x1 + y1 < x2 + y2) {
									borderLine = x1 + "_" + y1 + "_" + x2 + "_" + y2;
								} else {
									borderLine = x2 + "_" + y2 + "_" + x1 + "_" + y1;
								}
								if (joinablePolygons.containsKey(borderLine)) {
									Set set = (Set)joinablePolygons.get(borderLine);
									set.add(figureName + "_" + diagramTypeCode + "_" + polygonIndex);
								} else {
									Set set = new HashSet();
									set.add(figureName + "_" + diagramTypeCode + "_" + polygonIndex);
									joinablePolygons.put(borderLine, set);
								}
							}
						}
					} else {
						System.out.println("̤ĤޤǤ" + (figureName + arcIndexAbs));
					}
				}
			}
			if (polygon != null) {
				polygon.setZOrder(zOrder);
				polygons.put(figureName + "_" + diagramTypeCode + "_" + polygonIndex, polygon);
			}
		} catch (IOException e) {
		}
		this.polygons.putAll(polygons);
	}
}
