import java.awt.*;
import java.awt.event.*;
import java.awt.geom.Rectangle2D;
import java.util.*;
/*
 * : 2003/10/30
 */
/**
 * ϿΥǥǤ
 * @author Kumano Tatsuo
 */
public class LabelingDemoKobe {
	static LoadMap loadMap;
	static MapFrame frame;
	/**
	 * ƥѤΥ᥽åɤǤ
	 * @param arg ޥɥ饤
	 */
	public static void main(String[] args) {
		// ǡɤ߹
		loadMap = new LoadMap();
		String baseDir = "../map_data/suchi_chizu_2500/hyogo/";
		String files[] = loadMap.getDirList(baseDir);
		for (int i = 0; i < files.length; i++) {
			String files2[] = loadMap.getDirList(baseDir + files[i] + "/");
			if (files2 != null) {
				for (int j = 0; j < files2.length; j++) {
					System.out.println("loading " + baseDir + files[i] + "/" + files2[j] + "/");
					loadMap.loadArc(baseDir + files[i] + "/" + files2[j] + "/gyousei/gyousei.arc");
					loadMap.loadPolygon(
						baseDir + files[i] + "/" + files2[j] + "/gyousei/tyome.pgn",
						0,
						null,
						null,
						Color.RED,
						20);
					loadMap.loadAttribute(baseDir + files[i] + "/" + files2[j] + "/gyousei/tyome.atr");
				}
				for (int j = 0; j < files2.length; j++) {
					loadMap.loadArc(baseDir + files[i] + "/" + files2[j] + "/tatemono/tatemono.arc");
					loadMap.loadPolygon(
						baseDir + files[i] + "/" + files2[j] + "/tatemono/tatemono.pgn",
						2,
						Color.GRAY,
						null,
						Color.BLACK,
						20);
					loadMap.loadAttribute(baseDir + files[i] + "/" + files2[j] + "/tatemono/tatemono.atr");
				}
			}
		}
		loadMap.joinPolygons();
		loadMap.arrangeLabels();
		// ɤ߹ǡɽ
		frame = new MapFrame();
		frame.show();
		ShapePanel panel = (ShapePanel)frame.shapePanel;
		panel.addMapListener(new MapListener() {
			public void mapZoomChanged(MapEvent e) {
				ShapePanel panel = (ShapePanel)frame.shapePanel;
				double zoom = panel.getZoom();
				Font font = new Font("Arial", Font.PLAIN, (int) (12 / zoom));
				Map polygons = loadMap.getPolygons();
				Set keys = polygons.keySet();
				Iterator iterator = keys.iterator();
				while (iterator.hasNext()) {
					Object key = iterator.next();
					DrawablePolygon polygon = (DrawablePolygon)polygons.get(key);
					polygon.setFont(font);
				}
				frame.repaint();
			}
			public void mapMoved(MapEvent e) {
				ShapePanel panel = (ShapePanel)frame.shapePanel;
				double zoom = panel.getZoom();
				Font font = new Font("Arial", Font.PLAIN, (int) (12 / zoom));
				FontMetrics metrics = frame.getFontMetrics(font);
			}
		});
		frame.button1.setText("(I)");
		frame.button2.setText("ʣ(D)");
		frame.button1.setMnemonic('I');
		frame.button2.setMnemonic('D');
		frame.button1.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				// ٥֤᤹
				ShapePanel panel = (ShapePanel)frame.shapePanel;
				double zoom = panel.getZoom();
				long startTime = System.currentTimeMillis();
				Font font = new Font("Arial", Font.PLAIN, (int) (12 / zoom));
				for (Iterator iterator = loadMap.getPolygons().entrySet().iterator(); iterator.hasNext();) {
					DrawablePolygon polygon = (DrawablePolygon) ((Map.Entry)iterator.next()).getValue();
					if (panel.isVisible((Shape)polygon)) {
						polygon.setFont(font);
					}
				}
				frame.shapePanel.repaint();
				frame.outText.setText(
					frame.outText.getText()
						+ "֡\n"
						+ (System.currentTimeMillis() - startTime)
						+ " ms μ¹Ի\n");
			}
		});
		frame.button2.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				// ŤʤäƤ٥
				ShapePanel panel = (ShapePanel)frame.shapePanel;
				double zoom = panel.getZoom();
				long startTime = System.currentTimeMillis();
				int visibleLabelCount = 0;
				int invisibleLabelCount = 0;
				Font font = new Font("Arial", Font.PLAIN, (int) (12 / zoom));
				FontMetrics metrics = frame.shapePanel.getFontMetrics(font);
				Set fixedPolygons = new HashSet();
				for (Iterator iterator = loadMap.getPolygons().entrySet().iterator(); iterator.hasNext();) {
					Map.Entry entry = (Map.Entry)iterator.next();
					DrawablePolygon polygon = (DrawablePolygon)entry.getValue();
					Rectangle2D label =
						new Rectangle2D.Double(
							polygon.getLabelLocation().getX(),
							polygon.getLabelLocation().getY(),
							metrics.stringWidth(polygon.getLabel()),
							metrics.getAscent());
					if (panel.isVisible((Shape)polygon) || panel.isVisible(label)) {
						boolean isConflicting = false;
						for (Iterator iterator2 = fixedPolygons.iterator(); iterator2.hasNext();) {
							DrawablePolygon polygon2 =
								(DrawablePolygon)loadMap.getPolygons().get(iterator2.next());
							Rectangle2D label2 =
								new Rectangle2D.Double(
									polygon2.getLabelLocation().getX(),
									polygon2.getLabelLocation().getY(),
									metrics.stringWidth(polygon2.getLabel()),
									metrics.getAscent());
							if (label.intersects(label2)) {
								isConflicting = true;
								break;
							}
						}
						if (!isConflicting) {
							// ٥ɽ
							polygon.setFont(font);
							fixedPolygons.add(entry.getKey());
							visibleLabelCount++;
						} else {
							// ٥ɽʤ
							polygon.setFont(null);
							invisibleLabelCount++;
						}
					}
				}
				frame.shapePanel.repaint();
				frame.outText.setText(
					frame.outText.getText()
						+ "ʣ\n"
						+ (System.currentTimeMillis() - startTime)
						+ " ms μ¹Ի\n"
						+ ((double)visibleLabelCount / (visibleLabelCount + invisibleLabelCount))
						+ " Ψ\n");
			}
		});
		frame.button3.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				// button3 줿
				frame.outText.setText(frame.outText.getText() + "button3 줿\n");
			}
		});
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e1) {
			e1.printStackTrace();
		}
		panel.setData(loadMap.getData());
	}
}
