<?php
// $Id: index.php,v 1.1.1.1 2011/12/15 02:50:13 ohwada Exp $

//================================================================
// GooglePlus Module
// 2011-12-12 K.OHWADA
//================================================================

//---------------------------------------------------------
// header
//---------------------------------------------------------
include 'header.php';

//---------------------------------------------------------
// main
//---------------------------------------------------------
$xoops_cube_legacy = false;
if (defined('XOOPS_CUBE_LEGACY')) {
	$xoops_cube_legacy = true;
}

$code = isset($_GET['code']) ? $_GET['code'] : null; 
$msg  = isset($_GET['msg'])  ? $_GET['msg']  : null; 

$message = '';
$error   = '';
$feeds   = null;
$show_feeds  = false;
$feeds_error = '';

$description = $xoopsModuleConfig['description'] ;

// if NOT login
if (empty($xoopsUser)) {
	$xoopsOption['template_main'] = 'googleplus_please_login.html';
	include XOOPS_ROOT_PATH.'/header.php';

	$xoopsTpl->assign('show_login_password', true );
	$xoopsTpl->assign('show_login_googleplus', true );
	$xoopsTpl->assign('show_login_twitter',  
		googleplus_module_exsists( 'twitter' ) );
	$xoopsTpl->assign('show_login_facebook',  
		googleplus_module_exsists( 'facebook' ) );
	$xoopsTpl->assign('show_login_openid',   
		googleplus_module_exsists( 'exauth_openid' ) );

	$xoopsTpl->assign('xoops_cube_legacy',   $xoops_cube_legacy );
	$xoopsTpl->assign('description',         $description);  
	$xoopsTpl->assign('lang_please_login',     _GOOGLEPLUS_PLEASE_LOGIN );
	$xoopsTpl->assign('lang_login_password',   _GOOGLEPLUS_LOGIN_PASSWORD );
	$xoopsTpl->assign('lang_login_googleplus', _GOOGLEPLUS_LOGIN_GOOGLEPLUS );
	$xoopsTpl->assign('lang_login_twitter',    _GOOGLEPLUS_LOGIN_TWITTER );
	$xoopsTpl->assign('lang_login_facebook',   _GOOGLEPLUS_LOGIN_FACEBOOK );
	$xoopsTpl->assign('lang_login_openid',     _GOOGLEPLUS_LOGIN_OPENID );
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

$uid = $xoopsUser->getVar('uid');

$service =& googleplus_xoops_service::getInstance();
$exauth  =& $service->get_exauth_Instance();

$ret = $service->init();

// if NOT set App ID
if ( !$ret ) {
	$xoopsOption['template_main'] = 'googleplus_error.html';
	include XOOPS_ROOT_PATH.'/header.php';
	$xoopsTpl->assign('error', _GOOGLEPLUS_ERR_CLIENT_ID );
	$xoopsTpl->assign('show_goto_admin', true );
	$xoopsTpl->assign('lang_goto_admin', _GOOGLEPLUS_GOTO_ADMIN );
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

$ret = $service->set_user_param( $uid );

// if NOT set user param
if ( !$ret ) {
	$code  = $service->get_error_code();
	$error = $service->get_error_msg();

	$flag_exauth_id = false;
	if ( $code == -2 ) {
		$flag_exauth_id = true;
	}

	$xoopsOption['template_main'] = 'googleplus_please_googleplus.html';
	include XOOPS_ROOT_PATH.'/header.php';
	$xoopsTpl->assign('xoops_cube_legacy', $xoops_cube_legacy );
	$xoopsTpl->assign('error',             $error);
	$xoopsTpl->assign('flag_exauth_id',    $flag_exauth_id);  
	$xoopsTpl->assign('lang_please_googleplus_id', _GOOGLEPLUS_PLEASE_GOOGLEPLUS_ID );
	$xoopsTpl->assign('lang_login_googleplus',     _GOOGLEPLUS_LOGIN_GOOGLEPLUS );
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

$user = $service->get_user_me();

// if NOT get user info
if ( !$user ) {
	$error  = _GOOGLEPLUS_ERR_USER;
	$error .= '<br />';
	$error .= $service->get_error_msg();

	$xoopsOption['template_main'] = 'googleplus_error.html';
	include XOOPS_ROOT_PATH.'/header.php';
	$xoopsTpl->assign('error', $error );
	$xoopsTpl->assign('show_goto_admin', true );
	$xoopsTpl->assign('lang_goto_admin', _GOOGLEPLUS_GOTO_ADMIN );
	include XOOPS_ROOT_PATH.'/footer.php';
	exit();
}

switch ($code)
{
	case 0:
		break;

	case 1:
		$message = _GOOGLEPLUS_POST_SUCCESS;
		break;

	default:
		$error = $service->get_post_error( $code, $msg );
		break;
}

$token = $xoopsGTicket->issue();

$feeds = $service->get_me_feeds();

// if get News Feeds
if ( is_array($feeds) ) {
	$show_feeds = true;

// if NOT get News Feeds
} else {
	$feeds_error  = _GOOGLEPLUS_ERR_FEEDS;
	$feeds_error .= '<br />';
	$feeds_error .= $service->get_error_msg();
}

$xoopsOption['template_main'] = 'googleplus_index.html';
include XOOPS_ROOT_PATH.'/header.php';

$xoopsTpl->assign('message',     $message );
$xoopsTpl->assign('error',       $error );
$xoopsTpl->assign('feeds',       $feeds );
$xoopsTpl->assign('show_feeds',  $show_feeds );
$xoopsTpl->assign('feeds_error', $feeds_error );
$xoopsTpl->assign('user',        $user ); 
$xoopsTpl->assign('token',       $token );
//$xoopsTpl->assign('show_form',   $service->get_scope_publish_stream() );
$xoopsTpl->assign('lang_post',      _GOOGLEPLUS_POST );
$xoopsTpl->assign('lang_post_what', _GOOGLEPLUS_POST_WHAT );

include XOOPS_ROOT_PATH.'/footer.php';
exit();
// === main end ===

function googleplus_module_exsists( $name )
{
	$module_handler =& xoops_gethandler('module');
	$module = $module_handler->getByDirname( $name );
	if ( is_object($module) ) {
		return true;
	}
	return false;
}

?>