<?php
// $Id: oninstall.class.php,v 1.1.1.1 2011/12/15 02:50:13 ohwada Exp $

//=========================================================
// GooglePlus Module
// 2011-12-12 K.OHWADA
//=========================================================

//=========================================================
// class googleplus_oninstall
//=========================================================
class googleplus_oninstall
{
	var $_db = null;
	var $_db_error = null;
	var $_table_config = null;

	var $_DEBUG_SQL   = false;
	var $_DEBUG_ERROR = 0 ;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function googleplus_oninstall()
{
	$this->_db =& Database::getInstance();
	$this->_table_config = $this->_db->prefix("config");
}

function &getInstance()
{
	static $instance;
	if (!isset($instance))  {
		$instance =& new googleplus_oninstall();
	}
	return $instance;
}

//---------------------------------------------------------
// xoops config table
//---------------------------------------------------------
function update_xoops_config()
{
	// configs (Though I know it is not a recommended way...)
	$table_config = $this->_db->prefix("config");

	$check1 = $this->check_type_length( 'conf_name',  25 );
	$check2 = $this->check_type_length( 'conf_title', 30 );
	$check3 = $this->check_type_length( 'conf_desc',  30 );

	if ( $check1 && $check2 && $check3 ) {
		return true;
	}

	$sql  = "ALTER TABLE ". $this->_table_config;
	$sql .= " MODIFY `conf_name`  varchar(255) NOT NULL default '', ";
	$sql .= " MODIFY `conf_title` varchar(255) NOT NULL default '', ";
	$sql .= " MODIFY `conf_desc`  varchar(255) NOT NULL default '' ";

	return $this->query( $sql );
}

function check_type_length( $field_name, $length )
{
	$check_sql = "SHOW COLUMNS FROM ". $this->_table_config ." LIKE '". $field_name ."'" ;
	$row = $this->get_row_by_sql( $check_sql );
	if ( !is_array($row) ) { 
		return false; 
	}

	if ( preg_match( '/varchar\((\d+)\)/i', $row['Type'], $matches ) ) {
		if ( $matches[1] > $length ) {
			return true; 
		}
	}

	return false;
}

//---------------------------------------------------------
// query
//---------------------------------------------------------
function get_row_by_sql( $sql )
{
	$res = $this->query( $sql );
	if ( !$res ) { return false; }

	$row = $this->_db->fetchArray($res);
	return $row; 
}

function query( $sql, $limit=0, $offset=0, $force=false )
{
	$flag_echo_sql = false;

	if ( $force ) {
		return $this->queryF( $sql, $limit, $offset );
	}

	$sql_full = $sql .': limit='. $limit .' :offset='. $offset ;

	if ( $this->_DEBUG_SQL ) {
		$flag_echo_sql = true;
		echo $this->sanitize( $sql_full )."<br />\n";
	}

	$res = $this->_db->query( $sql, intval($limit), intval($offset) );
	if ( !$res  ) {
		$this->_db_error = $this->_db->error();
		if ( empty($error) ) {
			$error = 'Database update not allowed during processing of a GET request';
		}
		if ( $this->_DEBUG_SQL && !$flag_echo_sql ) {
			echo $this->sanitize( $sql_full )."<br />\n";
		}
		if ( $this->_DEBUG_ERROR ) {
			echo $this->highlight( $this->_db_error )."<br />\n";
		}
		if ( $this->_DEBUG_ERROR > 1 ) {
			debug_print_backtrace() ;
		}
	}

	return $res;
}

function queryF( $sql, $limit=0, $offset=0 )
{
	if ( $this->_DEBUG_SQL ) {
		echo $this->sanitize( $sql ) .': limit='. $limit .' :offset='. $offset. "<br />\n";
	}

	$res = $this->_db->queryF( $sql, intval($limit), intval($offset) );
	if ( !$res ) {
		$this->_db_error = $this->_db->error();
		if ( $this->_DEBUG_ERROR ) {
			echo $this->highlight( $this->_db_error )."<br />\n";
		}
	}

	return $res;
}

//---------------------------------------------------------
// error
//---------------------------------------------------------
function get_db_error( $flag_sanitize=true, $flag_highlight=true )
{
	$str = $this->_db_error;
	if ( $flag_sanitize ) {
		$str = $this->sanitize( $str );
	}
	if ( $flag_highlight ) {
		$str = $this->highlight( $str );
	}
	return $str;
}

function sanitize( $str )
{
	return htmlspecialchars( $str, ENT_QUOTES );
}

function highlight( $str )
{
	$val = '<span style="color:#ff0000;">'. $str .'</span>';
	return $val;
}

//---------------------------------------------------------
// debug
//---------------------------------------------------------
function set_debug_sql( $val )
{
	$this->_DEBUG_SQL = (bool)$val;
}

function set_debug_error( $val )
{
	$this->_DEBUG_ERROR = intval($val);
}

// --- class end ---
}

?>