<?php
// $Id: googleplus_xoops_service.class.php,v 1.1.1.1 2011/12/15 02:50:13 ohwada Exp $

//================================================================
// GooglePlus Module
// 2011-12-12 K.OHWADA
//================================================================

if ( !defined('_GOOGLEPLUS_LOADED') ) {

	define('_GOOGLEPLUS_LOADED', '1' );
	define('GOOGLEPLUS_DIR', XOOPS_ROOT_PATH. '/modules/googleplus' );

	include_once GOOGLEPLUS_DIR.'/class/config.class.php';

	require_once GOOGLEPLUS_DIR.'/class/google-api-php-client/src/apiClient.php';
	require_once GOOGLEPLUS_DIR.'/class/google-api-php-client/src/contrib/apiPlusService.php';
	require_once GOOGLEPLUS_DIR.'/class/service.class.php';
	require_once GOOGLEPLUS_DIR.'/class/exauth_base.class.php';
	require_once GOOGLEPLUS_DIR.'/class/exauth.class.php';
}

//================================================================
// class googleplus_xoops_service
//================================================================
class googleplus_xoops_service
{
	var $_service = null;
	var $_exauth  = null;
	var $_config  = null;

	var $_scope_plus_me = true;

	var $_error_code = 0;
	var $_error_msg  = null;

	var $_EXAUTH_TYPE  = 'googleplus';
	var $_SESSION_NAME_CALLBACK = 'googleplus_callback';
	var $_URL_CALLBACK = null;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function googleplus_xoops_service()
{
	$this->_service =& googleplus_service::getInstance();
	$this->_exauth  =& googleplus_exauth::getInstance();
	$this->_config  =& googleplus_config::getInstance();

	$this->_URL_CALLBACK = XOOPS_URL . '/modules/googleplus/callback.php';
}

function &getInstance()
{
	static $instance;
	if (!isset($instance))  {
		$instance =& new googleplus_xoops_service();
	}
	return $instance;
}

function &get_exauth_Instance()
{
	return $this->_exauth;
}

function get_error_code() 
{
	return $this->_error_code ;
}

function get_error_msg() 
{
	return $this->_error_msg ;
}

//---------------------------------------------------------
// Initialization
//---------------------------------------------------------
function init()
{
	$name   = '';
	$id     = '';
	$secret = '';
	$key    = '';

	$config = $this->_config->get_config();
	if ( is_array($config) ) {
		$name   = $config['app_name'];
		$id     = $config['client_id'];
		$secret = $config['client_secret'];
		$key    = $config['developer_key'];
	}

	if( empty($id) || empty($secret) || empty($key) ) {
		return false;
	}

	$this->_service->set_application_name( $name );
	$this->_service->set_client_id(        $id );
	$this->_service->set_client_secret(    $secret );
	$this->_service->set_developer_key(    $key );
	$this->_service->set_url_callback(  $this->_URL_CALLBACK );
	$this->_service->set_scope_plus_me( $this->_scope_plus_me );

	$this->_service->init_api_client();
	$this->_service->init_plus_service();

	$this->unset_session_callback();

	return true;
}

//---------------------------------------------------------
// session
//---------------------------------------------------------
function set_session_callback( $v=2 )
{
	$_SESSION[ $this->_SESSION_NAME_CALLBACK ] = $v;
}

function get_session_callback()
{
	if ( isset( $_SESSION[ $this->_SESSION_NAME_CALLBACK ] ) ) {
		return  $_SESSION[ $this->_SESSION_NAME_CALLBACK ];
	}
	return false;
}

function unset_session_callback()
{
	unset( $_SESSION[ $this->_SESSION_NAME_CALLBACK ] );
}

//---------------------------------------------------------
// Redirect to GooglePlus server
//---------------------------------------------------------
function login()
{
	$ret = $this->_service->login();
	if ( !$ret ) {
		$this->_error_code = $this->_service->get_error_code();
		$this->_error_msg  = $this->_service->get_error_msg();
        return false;
	}
	return true;
}

//---------------------------------------------------------
// get GooglePlus ID
//---------------------------------------------------------
function callback()
{
	$param = $this->_service->callback();
	if ( !is_array($param) ) {
		$this->_error_code = $this->_service->get_error_code();
		$this->_error_msg  = $this->_service->get_error_msg();
        return false;
	}

	$user = $this->_service->get_people( 'me' );
	if ( !isset($user['id']) ) {
		$this->_error_code = 22;
		return false;
	}

	$ret = array(
		'token'   => $param['token'] ,
		'user_id' => $user['id'] ,
	);
	return $ret;
}

//---------------------------------------------------------
// set user param
//---------------------------------------------------------
function set_user_param( $user_id ) 
{
	$token = $this->get_user_token( $user_id );
	if( empty($token) ) {
		return false;
	}

	$this->_service->set_client_access_token( $token );
	return true;
}

function get_user_token( $uid )
{
	$id = $this->_exauth->get_exauth_id( $uid );
	if ( empty($id) ) {
		$this->_error_code = -1;
		$this->_error_msg  = _GOOGLEPLUS_ERR_GOOGLEPLUS_ID;
		return false;	// NOT set ID
	}

	$token = $this->_exauth->get_user_token( $uid );

	if( empty($token) ) {
		$this->_error_code = -2;
		$this->_error_msg  = _GOOGLEPLUS_ERR_TOKEN;
		return false;
	}

	return $token;
}

//---------------------------------------------------------
// get user me
//---------------------------------------------------------
function get_user_me()
{
	$user = $this->_service->get_people('me');
	if ( !is_array($user) ) {
		$this->_error_code = $this->_service->get_error_code();
		$this->_error_msg  = $this->_service->get_error_msg();
       	return false;
	}

	$user = $this->_service->person_to_flat( $user );
	$user = $this->_service->convert_encoding_person( $user, _CHARSET );
	return $user;
}

//---------------------------------------------------------
// get news feeds
//---------------------------------------------------------
function get_me_feeds()
{
	$feeds = $this->_service->get_activity_feeds( 'me', 10 );
	if ( !$feeds ) {
		$this->_error_code = $this->_service->get_error_code();
		$this->_error_msg  = $this->_service->get_error_msg();
        return false;
	}

	$feeds = $this->_service->activity_feeds_to_flat( $feeds );
	$feeds = $this->_service->convert_encoding_activity_feeds( $feeds, _CHARSET );
	return $feeds['items'];
}

//---------------------------------------------------------
// post
//---------------------------------------------------------
function post( $msg )
{
	$msg = $this->convert_to_utf8( $msg );
	$ret = $this->_service->post_me_feed( $msg );
	if ( !$ret ) {
		$this->_error_code = $this->_service->get_error_code();
		$this->_error_msg  = $this->_service->get_error_msg();
        return false;
	}
	return true;
}

function get_post_error( $code, $msg )
{
	switch ($code)
	{
		case 61:
			$error = _GOOGLEPLUS_ERR_POST_EMPTY;
			break;

		case 62:
			$error  = _GOOGLEPLUS_ERR_POST_FAIL.'<br />';
			$error .= $msg;
			break;

		default:
			$error = _GOOGLEPLUS_ERR_SOMETHING;
			break;
	}
	return $error;
}

function convert_to_utf8( $str ) 
{
	return $this->_service->convert_to_utf8( $str, _CHARSET ); 
}

// === class end ===

}

?>