<?php
// $Id: admin.php,v 1.2 2011/12/15 03:14:42 ohwada Exp $

//================================================================
// GooglePlus Plugin of Exauth Module
// 2011-12-12 K.OHWADA
//================================================================

//---------------------------------------------------------
// copy from openid 
//---------------------------------------------------------

/** Local Library Include */
require_once XOOPS_ROOT_PATH . '/modules/exauth/include/exauth_function.php';

// Load Module Language file //
if (defined('XOOPS_CUBE_LEGACY')) {
} else {
    exauth_loadMyModuleLanguage('modinfo');
    exauth_loadMyModuleLanguage('main');
    exauth_loadModuleLanguage('system', 'admin');
}

require_once XOOPS_ROOT_PATH . '/modules/exauth/class/exauth_themeformhelper.php';

// Get text sanitizer //
$myts =& MyTextSanitizer::getInstance();

$xoopsConfigMyModule =& $config_handler->getConfigsByCat(0, $xoopsModule->getVar('mid', 'n'));

$theme_form_info = array();

if ($plugin->mPluginInfo->getVar('official_page')) {
    $theme_form_info['label1'] = array(
      'formtype' => 'HtmlLabel',
      'caption'  => '<div style="text-align:left;padding-left:5px;font-weight:bold;">'._AD_EXAUTH_OFFICIAL.'</div>',
      'label'    => '<a href="'.$plugin->mPluginInfo->getVar('official_page').'" target="_blank">' . $plugin->getAuthName() . '</a>',
      'on_freeze_hide' => true,
    );
}
$callback = $plugin->getCallbackURL();
if ($callback) {
    $theme_form_info['label2'] = array(
      'formtype' => 'HtmlLabel',
      'caption'  => '<div style="text-align:left;padding-left:5px;font-weight:bold;">'._AD_EXAUTH_CALLBACK.'</div>',
      'label'    => '<input type="text" onfocus="this.select();" onclick="this.focus(); this.select();" size="100" value="' . $myts->htmlSpecialChars($callback) . '"><br />' . sprintf(_AD_EXAUTH_CALLBACK_DESC, $plugin->getAuthName()),
      'on_freeze_hide' => true,
    );
}

$theme_form_info['label3'] = array(
  'formtype' => 'HtmlLabel',
  'caption'  => '<div style="text-align:left;padding-left:5px;font-weight:bold;">'._MD_EXAUTH_STATUS.'</div>',
  'label'    =>
  '<table>' .
  '<tr><td>cURL</td><td>'.(function_exists('curl_init')?'<span style="color:#0000FF">'._MD_EXAUTH_ENABLE.'</span>':'<span style="color:#FF0000">'._MD_EXAUTH_DISABLE.'</span>').'</td></tr>'.
  '<tr><td>OpenSSL</td><td>'.(function_exists('openssl_open')?'<span style="color:#0000FF">'._MD_EXAUTH_ENABLE.'</span>':'<span style="color:#FF0000">'._MD_EXAUTH_DISABLE.'</span>').'</td></tr>'.

// for openid
//  '<tr><td>CERT File</td><td>'.
//    (is_file($xoopsConfigMyModule['exauth_oid_curlcert'])?
//      '<span style="color:#0000FF">'._MD_EXAUTH_ENABLE.'</span> ('.date("Y/m/d H:i:s", filemtime($xoopsConfigMyModule['exauth_oid_curlcert'])).' Mod.)':'<span style="color:#FF0000">'._MD_EXAUTH_DISABLE.'</span>').
//  '<br />'.
//  '<a href="'.XOOPS_URL.'/modules/exauth_openid/admin/index.php?m=UpdateCert">Update Now!</a>'.'</td></tr>'.
// ---

  '</table>',
  'on_freeze_hide' => true,
);

$plugin_config = $plugin->mPluginInfo->getVar('config');

foreach ($plugin_config as $config) {
    $theme_form_info[$config['name']]['caption'] =
      '<div style="text-align:left;padding-left:5px;font-weight:bold;">'.constant($config['title']).
        '<p style="text-align:left;padding-left:5px;font-weight:normal;">'.constant($config['description']).'</p></div>';
    switch ($config['formtype']) {
    case 'text':
    default:
        $theme_form_info[$config['name']]['formtype'] = 'Text';
        break;
    case 'select':
        $theme_form_info[$config['name']]['formtype'] = 'Select';
        foreach ($config['options'] as $k => $v) {
            $theme_form_info[$config['name']]['option'][$v] = constant($k);
        }
        break;
    case 'yesno':
        $theme_form_info[$config['name']]['formtype'] = 'RadioYN';
        break;
    case 'group_multi':
        $theme_form_info[$config['name']]['formtype'] = 'GroupMulti';
        break;
    case 'textarea':
        $theme_form_info[$config['name']]['formtype'] = 'TextArea';
        break;
    }
    $theme_form_info[$config['name']]['filter'] = array('trim');
}
$theme_form_info['exauth_oid_set_urandom']['filter'][] = 'exauth_openid_fileter_localfilename';

$form = new exauth_ThemeFormHelper($plugin->mPluginInfo->getVar('name'), $exauth.'info', $_SERVER['PHP_SELF'].'?exauth='.$exauth, 'post', $theme_form_info);

switch ($form->getOperation()) {
case 'finish':
    if (!$form->checkTicket()) {
        xoops_cp_header();
        xoops_error('Ticket Error');
        xoops_cp_footer();
        exit();
    }
    $form->importRequestValues();
    $form->applyFilter();
    $stop = $form->validate();
    if (!empty($stop)) {
        xoops_cp_header();
        /** @ignore */
        echo '<div class="adminnavi"><a href="./index.php">'._MI_EXAUTH_NAME.'</a> &raquo;&raquo; <span class="adminnaviTitle">'._MI_EXAUTH_OPENID_INFO.'</span></div>';
        include('./mymenu.php');
        echo '<span style="color: red;">' . $stop . '</span>';
        $form->setOperation(array('finish' => _MD_EXAUTH_REGIST_SUBMIT));
        $form->enableTicket();
        $form->display();
        xoops_cp_footer();
        exit();
    }
    $config_handler =& xoops_gethandler('config');

    $urandom = $form->getVar('exauth_oid_set_urandom');
    if ($urandom != '') {
        $f = @fopen($urandom, 'r');
        if ($f === false) {
            $form->setVar('exauth_oid_set_urandom', '');
        } else {
            fclose($f);
        }
    }
    $default_groups = $form->getVar('exauth_oid_def_group');
    if (!is_array($default_groups)||count($default_groups)==0) {
        $default_groups = array(XOOPS_GROUP_USERS);
    }
    $form->setVar('exauth_oid_def_group', $default_groups);
    foreach ($plugin_config as $config) {
        $obj_config =& $config_handler->getConfigs(new Criteria('conf_name', $config['name']));
        $var = $form->getVar($config['name']);
        if (is_array($var)) {
            $var = serialize($var);
        }
        $obj_config[0]->setVar('conf_value', $var, true);
        $config_handler->insertConfig($obj_config[0]);
    }
    $form->clearSessionValues();
    redirect_header($_SERVER['PHP_SELF'].'?exauth='.$exauth, 1, _AD_EXAUTH_DBUPDATED);
    break;
default:
    $config_handler =& xoops_gethandler('config');
    foreach ($plugin_config as $config) {
        $form->setVar($config['name'], $xoopsConfigMyModule[$config['name']]);
    }
    xoops_cp_header();
    /** @ignore */
    echo '<div class="adminnavi"><a href="./index.php">'._MI_EXAUTH_NAME.'</a> &raquo;&raquo; <span class="adminnaviTitle">'._MI_EXAUTH_OPENID_INFO.'</span></div>';
    include('./mymenu.php');

    $form->setOperation(array('finish' => _MD_EXAUTH_REGIST_SUBMIT));
    $form->enableTicket();
    $form->display();
    xoops_cp_footer();
    break;
}

function exauth_openid_fileter_localfilename($str) {
    $str = preg_replace('!^.*://!', '', $str);// delete scheme
    return $str;
}
