<?php
// $Id: List.class.php,v 1.1.1.1 2009/01/05 08:39:18 ohwada Exp $

//=========================================================
// Googlemap Netcommons
// 2009-01-01 K.OHWADA
//=========================================================

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Googlemap一覧画面表示
 *
 * @package     NetCommons
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Googlemap_View_Edit_List extends Action
{
	// パラメータを受け取るため
	var $module_id = null;
	var $block_id = null;
	var $scroll = null;

	// 使用コンポーネントを受け取るため
	var $googlemapView = null;
	var $request = null;
	var $filterChain = null;

	// validatorから受け取るため
	var $googlemapCount = null;

	// 値をセットするため
	var $visibleRows = null;
	var $googlemapList = null;
	var $currentGooglemapID = null;

    /**
     * Googlemap一覧画面表示アクション
     *
     * @access  public
     */
	function execute()
	{
    	//scrollが_ON以外の場合、Config変数を取得し limitを設定する
        if ($this->scroll != _ON) {
        	//Config変数の取得
			$config = $this->googlemapView->getConfig( $this->module_id );
			$this->visibleRows = $config['list_row_count'];

	        $this->request->setParameter("limit", $this->visibleRows);
	        $this->currentGooglemapID = $this->googlemapView->getCurrentGooglemapID();
	        if ($this->currentGooglemapID === false) {
	        	return "error";
	        }
		}

		//partsレコード一覧を取得する
		$this->googlemapList = $this->googlemapView->getGooglemapList();
        if (empty($this->googlemapList)) {
        	return "error";
        }

        //scrollが_ONの時、「テーマなし」に設定する。
        if ($this->scroll == _ON) {
			$view =& $this->filterChain->getFilterByName("View");
			$view->setAttribute("define:theme", 0);
        	return "scroll";
        }
        
        return "screen";
    }
}
?>
