<?php
/**
 * @package Legacy
 * @version $Id: SearchShowallbyuserAction.class.php,v 1.1.2.2 2006/10/14 15:44:10 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/legacy/actions/SearchShowallAction.class.php";
require_once XOOPS_MODULE_PATH . "/legacy/forms/SearchShowallbyuserForm.class.php";

class Legacy_SearchShowallbyuserAction extends Legacy_SearchShowallAction
{
	function _setupActionForm()
	{
		$this->mActionForm =& new Legacy_SearchShowallbyuserForm($this->mConfig['keyword_min']);
		$this->mActionForm->prepare();
	}
	
	function _getTemplateName()
	{
		return "legacy_search_showallbyuser.html";
	}
	
	function _getSelectedMids()
	{
		$ret = array();
		$ret[] = $this->mActionForm->get('mid');
		
		return $ret;
	}
	
	function _doSearch(&$client, &$xoopsUser, &$params)
	{
		return $client->call('searchItemsOfUser', $params);
	}

	function _getMaxHit()
	{
		return LEGACY_SEARCH_SHOWALL_MAXHIT;
	}
	
	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
		parent::executeViewIndex($controller, $xoopsUser, $render);
		
		$handler =& xoops_gethandler('user');
		$user =& $handler->get($this->mActionForm->get('uid'));
		
		$render->setAttribute('targetUser', $user);
	}
}

?>
