<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_LEGACY_PATH . "/admin/class/ModuleUtils.class.php";
require_once XOOPS_LEGACY_PATH . "/admin/class/ModuleInstallUtils.class.php";

class Legacy_ModuleUninstaller
{
	/**
	 * This instance is prepared automatically in the constructor.
	 * 
	 * @public
	 * @var Legacy_ModuleUtilsSimpleLog
	 */
	var $mLog = null;
	
	var $_mForceMode = false;
	
	/**
	 * @protected
	 * @var XoopsModule
	 */
	var $_mXoopsModule = null;
	
	function Legacy_ModuleUninstaller()
	{
		$this->mLog =& new Legacy_ModuleUtilsSimpleLog();
	}
	
	/**
	 * Sets the current XoopsModule.
	 * 
	 * @public
	 * @param XoopsModule $xoopsModule
	 */
	function setCurrentXoopsModule(&$xoopsModule)
	{
		$this->_mXoopsModule =& $xoopsModule;
	}
	
	/**
	 * Sets a value indicating whether the force mode is on.
	 * @param bool $isForceMode
	 */
	function setForceMode($isForceMode)
	{
		$this->_mForceMode = $isForceMode;
	}
	
	/**
	 * Deletes module information from XOOPS database because this class is
	 * uninstaller.
	 * 
	 * @protected
	 */
	function _uninstallModule()
	{
		$moduleHandler =& xoops_gethandler('module');
		if (!$moduleHandler->delete($this->_mXoopsModule)) {
			$this->mLog->addError(_AD_LEGACY_ERROR_DELETE_MODULEINFO_FROM_DB);
		}
		else {
			$this->mLog->addReport(_AD_LEGACY_MESSAGE_DELETE_MODULEINFO_FROM_DB);
		}
	}

	/**
	 * Drop table because this class is uninstaller.
	 * 
	 * @protected
	 */
	function _uninstallTables()
	{
		$root =& XCube_Root::getSingleton();
		$db =& $root->mController->getDB();

		$tables = $this->_mXoopsModule->getInfo('tables');
		if ($tables != false && is_array($tables)) {
			foreach($tables as $table) {
				//
				// TODO Do we need to check reserved core tables?
				//
				$sql = "DROP TABLE " . $db->prefix($table);
				if ($db->query($sql)) {
					$this->mLog->addReport(XCube_Utils::formatMessage(_AD_LEGACY_MESSAGE_DROP_TABLE, $db->prefix($table)));
				}
				else {
					$this->mLog->addError(XCube_Utils::formatMessage(_AD_LEGACY_ERROR_DROP_TABLE, $db->prefix($table)));
				}
			}
		}
	}

	/**
	 * Delete template because this class is uninstaller.
	 * @protected
	 */
	function _uninstallTemplates()
	{
		Legacy_ModuleInstallUtils::uninstallAllOfModuleTemplates($this->_mXoopsModule, $this->mLog, false);
	}

	/**
	 * Delete all of module's blocks.
	 * 
	 * @note Templates Delete is move into Legacy_ModuleInstallUtils.
	 */
	function _uninstallBlocks()
	{
		Legacy_ModuleInstallUtils::uninstallAllOfBlocks($this->_mXoopsModule, $this->mLog);

		//
		// Additional
		//
		$tplHandler =& xoops_gethandler('tplfile');
		$criteria =& new Criteria('tpl_module', $this->_mXoopsModule->get('dirname'));
		if(!$tplHandler->deleteAll($criteria)) {
			$this->mLog->addError(XCube_Utils::formatMessage(_AD_LEGACY_ERROR_COULD_NOT_DELETE_BLOCK_TEMPLATES, $tplHandler->db->error()));
		}
	}

	function _uninstallPreferences()
	{
		Legacy_ModuleInstallUtils::uninstallAllOfConfigs($this->_mXoopsModule, $this->mLog);
	}

	function _processScript()
	{
		$installScript = trim($this->_mXoopsModule->getInfo('onUninstall'));
		if ($installScript != false) {
			require_once XOOPS_MODULE_PATH . "/" . $this->_mXoopsModule->get('dirname') . "/" . $installScript;
			$funcName = 'xoops_module_uninstall_' . $this->_mXoopsModule->get('dirname');
			if (function_exists($funcName)) {
				if (!call_user_func($funcName, $this->_mXoopsModule)) {
					$this->mLog->addError(XCube_Utils::formatMessage(_AD_LEGACY_ERROR_FAILED_TO_EXECUTE_CALLBACK, $funcName));
				}
			}
		}
	}
	
	function _processReport()
	{
		if (!$this->mLog->hasError()) {
			$this->mLog->add(XCube_Utils::formatMessage(_AD_LEGACY_MESSAGE_UNINSTALLATION_MODULE_SUCCESSFUL, $this->_mXoopsModule->get('name')));
		}
		else {
			if (is_object($this->_mXoopsModule)) {
				$this->mLog->addError(XCube_Utils::formatMessage(_AD_LEGACY_ERROR_UNINSTALLATION_MODULE_FAILURE, $this->_mXoopsModule->get('name')));
			}
			else {
				$this->mLog->addError(XCube_Utils::formatMessage(_AD_LEGACY_ERROR_UNINSTALLATION_MODULE_FAILURE, $this->_mXoopsModule->get('dirname')));
			}
		}
	}

	/**
	 * @todo Check whether $this->_mXoopsObject is ready.
	 */
	function executeUninstall()
	{
		$this->_uninstallTables();
		if (!$this->_mForceMode && $this->mLog->hasError()) {
			$this->_processReport();
			return false;
		}

		$this->_uninstallModule();
		if (!$this->_mForceMode && $this->mLog->hasError()) {
			$this->_processReport();
			return false;
		}

		$this->_uninstallTemplates();
		if (!$this->_mForceMode && $this->mLog->hasError()) {
			$this->_processReport();
			return false;
		}

		$this->_uninstallBlocks();
		if (!$this->_mForceMode && $this->mLog->hasError()) {
			$this->_processReport();
			return false;
		}
		
		$this->_uninstallPreferences();
		if (!$this->_mForceMode && $this->mLog->hasError()) {
			$this->_processReport();
			return false;
		}
		
		$this->_processScript();
		
		$this->_processReport();
		
		return true;
	}
}

?>