<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/base/admin/forms/PreferenceEditForm.class.php";

class Legacy_PreferenceEditAction extends Legacy_Action
{
	var $mPreparedFlag = false;
	
	var $mCategory = null;
	var $mModule = null;

	var $mObjects = array();
	var $mActionForm = null;
	
	var $mState = null;

	function prepare(&$controller, &$xoopsUser)
	{
		$controller->mRoot->mLanguageManager->loadPageTypeMessageCatalog('comment');
		$controller->mRoot->mLanguageManager->loadPageTypeMessageCatalog('notification');

		$this->mState = (xoops_getrequest('confmod_id') > 0) ? new Legacy_ModulePreferenceEditState($this) : new Legacy_PreferenceEditState($this);
		$this->mState->prepare($controller, $xoopsUser);
		
		if ($this->mPreparedFlag) {
			$handler =& xoops_gethandler('config');
			
			$criteria =& new CriteriaCompo();
			$criteria->add(new Criteria('conf_modid', $this->mActionForm->getModuleId()));
			$criteria->add(new Criteria('conf_catid', $this->mActionForm->getCategoryId()));
			
			$this->mObjects =& $handler->getConfigs($criteria);
			$this->mActionForm->prepare($this->mObjects);
		}
	}
	
	function getDefaultView(&$controller, &$xoopsUser)
	{
		if (!$this->mPreparedFlag) {
			return LEGACY_FRAME_VIEW_ERROR;
		}
		
		return LEGACY_FRAME_VIEW_INPUT;
	}
	
	function execute(&$controller, &$xoopsUser)
	{
		if (!$this->mPreparedFlag) {
			return LEGACY_FRAME_VIEW_ERROR;
		}
		
		if (xoops_getrequest('_form_control_cancel') != null) {
			return LEGACY_FRAME_VIEW_CANCEL;
		}
		
		$this->mActionForm->fetch();
		$this->mActionForm->validate();
		
		if ($this->mActionForm->hasError()) {
			return $this->getDefaultView($controller, $xoopsUser);
		}
		
		$this->mActionForm->update($this->mObjects);
		$handler =& xoops_gethandler('config');
		
		foreach (array_keys($this->mObjects) as $key) {
			if (!$handler->insertConfig($this->mObjects[$key])) {
				die("ERROR" . $this->mObjects[$key]->get('conf_name'));
			}
		}
		
		return LEGACY_FRAME_VIEW_SUCCESS;
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("preference_edit.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		$render->setAttribute('objectArr', $this->mObjects);
		
		$render->setAttribute('category', $this->mCategory);
		$render->setAttribute('module', $this->mModule);
		
		$handler =& xoops_gethandler('timezone');
		$timezoneArr =& $handler->getObjects();
		$render->setAttribute('timezoneArr', $timezoneArr);
		
		$handler =& xoops_gethandler('group');
		$groupArr =& $handler->getObjects();
		$render->setAttribute('groupArr', $groupArr);

		//
		// Make the array of tplset object
		//
		$handler =& xoops_gethandler('tplset');
		$tplsetArr =& $handler->getObjects();
		$render->setAttribute('tplsetArr', $tplsetArr);
		
		//
		// Make the list of installed languages.
		//
		$languageArr = array();
		$dirHandler = opendir(XOOPS_ROOT_PATH . "/language/");
		while ($file = readdir($dirHandler)) {
			if (is_dir(XOOPS_ROOT_PATH . "/language/" . $file) && preg_match("/^[a-z_]+$/", $file)) {
				$languageArr[$file] = $file;
			}
		}
		closedir($dirHandler);
		$render->setAttribute('languageArr', $languageArr);
		
		
		//
		// Make the array of module object for selecting startpage.
		//
		$handler =& xoops_gethandler('module');
		$criteria =& new CriteriaCompo();
		$criteria->add(new Criteria('hasmain', 1));
		$criteria->add(new Criteria('isactive', 1));
		$moduleArr = $handler->getObjects($criteria);
		$render->setAttribute('moduleArr', $moduleArr);
		
		
		//
		// Make the list of theme.
		//
		$handler =& xoops_getmodulehandler('theme');
		$themeArr =& $handler->getObjects();
		$render->setAttribute('themeArr', $themeArr);
		
		//
		// Make the array of cachetime.
		//
		$handler =& xoops_gethandler('cachetime');
		$cachetimeArr = $handler->getObjects();
		$render->setAttribute('cachetimeArr', $cachetimeArr);
		
		//
		// Make the list of user
		//
		$handler =& xoops_gethandler('member');
		$userArr = $handler->getUserList();
		$render->setAttribute('userArr', $userArr);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$this->mState->executeViewSuccess($controller, $xoopsUser, $render);
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeRedirect("./index.php?action=PreferenceList", 1, _MD_BASE_ERROR_DBUPDATE_FAILED);
	}
	
	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
		$this->mState->executeViewCancel($controller, $xoopsUser, $render);
	}
}

class Legacy_AbstractPreferenceEditState
{
	var $_mMaster = null;

	function Legacy_AbstractPreferenceEditState(&$master)
	{
		$this->_mMaster =& $master;
	}
	
	function prepare(&$controller, &$xoopsUser)
	{
	}
	
	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
	}
}

class Legacy_PreferenceEditState extends Legacy_AbstractPreferenceEditState
{
	function prepare(&$controller, &$xoopsUser)
	{
		parent::prepare($controller, $xoopsUser);
		
		$handler =& xoops_gethandler('configcategory');
		$this->_mMaster->mCategory =& $handler->get(intval(xoops_getrequest('confcat_id')));
		
		if (!is_object($this->_mMaster->mCategory)) {
			return;
		}

		$this->_mMaster->mActionForm =& new Legacy_PreferenceEditForm($this->_mMaster->mCategory);
		
		$this->_mMaster->mPreparedFlag = true;
	}
	
	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=PreferenceList");
	}

	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=PreferenceList");
	}
}

class Legacy_ModulePreferenceEditState extends Legacy_AbstractPreferenceEditState
{
	function prepare(&$controller, &$xoopsUser)
	{
		parent::prepare($controller, $xoopsUser);
		
		$handler =& xoops_gethandler('module');
		$this->_mMaster->mModule =& $handler->get(intval(xoops_getrequest('confmod_id')));

		if (!is_object($this->_mMaster->mModule)) {
			return;
		}

		$this->_mMaster->mActionForm =& new Legacy_ModulePreferenceEditForm($this->_mMaster->mModule);
		
		//
		// Load constants
		//
		$root =& XCube_Root::getSingleton();
		$root->mLanguageManager->loadModinfoMessageCatalog($this->_mMaster->mModule->get('dirname'));
		
		$this->_mMaster->mPreparedFlag = true;
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		//
		// TODO The following URL is a wrong for some module which hasn't admin directory.
		//
		$controller->executeForward(XOOPS_MODULE_URL . '/' . $this->_mMaster->mModule->get('dirname') . '/admin/');
	}

	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
		//
		// TODO The following URL is a wrong for some module which hasn't admin directory.
		//
		$controller->executeForward(XOOPS_MODULE_URL . '/' . $this->_mMaster->mModule->get('dirname') . '/admin/');
	}
}

?>
