<?php
/**
 * @package Legacy
 * @version $Id: ModuleUninstallAction.class.php,v 1.1.2.8 2006/08/09 04:31:08 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_BASE_PATH . "/admin/actions/AbstractModuleInstallAction.class.php";
require_once XOOPS_BASE_PATH . "/admin/class/ModuleUninstaller.class.php";
require_once XOOPS_BASE_PATH . "/admin/forms/ModuleUninstallForm.class.php";

/**
 * Uninstall module
 */
class Legacy_ModuleUninstallAction extends Legacy_AbstractModuleInstallAction
{
	/**
	 * @var XCube_Delegate
	 */
	var $mUninstallSuccess = null;
	
	/**
	 * @var XCube_Delegate
	 */
	var $mUninstallFail = null;
	
	function Legacy_ModuleUninstallAction($flag)
	{
		parent::Legacy_AbstractModuleInstallAction($flag);
		
		$this->mUninstallSuccess =& new XCube_Delegate();
		$this->mUninstallSuccess->register('Legacy_ModuleUninstallAction.UninstallSuccess');
		
		$this->mUninstallFail =& new XCube_Delegate();
		$this->mUninstallFail->register('Legacy_ModuleUninstallAction.UninstallFail');
	}

	function &_getInstaller($dirname)
	{
		$installer =& new Legacy_ModuleUninstaller($dirname);
		return $installer;
	}
	
	function _setupActionForm()
	{
		$this->mActionForm =& new Legacy_ModuleUninstallForm();
		$this->mActionForm->prepare();
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$renderer)
	{
		if (!$this->mLog->hasError()) {
			$this->mUninstallSuccess->call(new XCube_Ref($this->mModuleObject), new XCube_Ref($this->mLog));
			XCube_DelegateUtils::call('Legacy.Admin.Event.ModuleUninstall.' . ucfirst($this->mModuleObject->get('dirname') . '.Success'), new XCube_Ref($this->mModuleObject), new XCube_Ref($this->mLog));
		}
		else {
			$this->mUninstallFail->call(new XCube_Ref($this->mModuleObject), new XCube_Ref($this->mLog));
			XCube_DelegateUtils::call('Legacy.Admin.Event.ModuleUninstall.' . ucfirst($this->mModuleObject->get('dirname') . '.Fail'), new XCube_Ref($this->mModuleObject), new XCube_Ref($this->mLog));
		}

		$renderer->setTemplateName("module_uninstall_success.html");
		$renderer->setAttribute('module',$this->mModuleObject);
		$renderer->setAttribute('log', $this->mLog->mMessages);
	}

	function executeViewIndex(&$controller, &$xoopsUser, &$renderer)
	{
		$renderer->setTemplateName("module_uninstall.html");
		$renderer->setAttribute('actionForm', $this->mActionForm);
		$renderer->setAttribute('module', $this->mModuleObject);
	}

	function executeViewInput(&$controller, &$xoopsUser, &$renderer)
	{
		$this->executeViewIndex(&$controller, &$xoopsUser, &$renderer);
	}

	function executeViewCancel(&$controller, &$xoopsUser, &$renderer)
	{
		$controller->executeForward("./index.php?action=ModuleList");
	}
}

?>