<?php

if (!defined('XOOPS_ROOT_PATH')) die();

class Pm_Preload extends XCube_ActionFilter
{
	function preBlockFilter()
	{
		$root =& XCube_Root::getSingleton();
		$root->mDelegateManager->add('Legacypage.Viewpmsg.Access', "Pm_Preload::accessToViewpmsg");
		$root->mDelegateManager->add('Legacypage.Readpmsg.Access', "Pm_Preload::accessToReadpmsg");
		$root->mDelegateManager->add('Legacypage.Pmlite.Access', "Pm_Preload::accessToPmlite");
		
		$this->mController->mGetPMInboxUrl->add("Pm_Preload::getPmInboxUrl");
		$this->mController->mGetCountUnreadPM->add("Pm_Preload::getCountUnreadPM");
	}
	
	function getPmInboxUrl(&$url, $uid)
	{
		if ($uid > 0) {
			$url = XOOPS_MODULE_URL . "/pm/index.php";
		}
	}
	
	function getCountUnreadPM(&$count, $uid)
	{
		if ($uid > 0) {
			$handler =& xoops_gethandler('privmessage');
			$count = $handler->getCountUnreadByFromUid($uid);
		}
	}
	
	function accessToReadpmsg()
	{
		$root =& XCube_Root::getSingleton();
		$root->mController->executeForward(XOOPS_MODULE_URL . "/pm/index.php?action=read&msg_id=" . intval(xoops_getrequest('msg_id')));
	}

	function accessToViewpmsg()
	{
		$root =& XCube_Root::getSingleton();
		$root->mController->executeForward(XOOPS_MODULE_URL . "/pm/index.php");
	}
	
	function accessToPmlite()
	{
		$root =& XCube_Root::getSingleton();
		
		//
		// Does this access request reply mode?
		//
		$reply = xoops_getrequest('reply');
		$msg_id = intval(xoops_getrequest('msg_id'));

		if ($reply == null ||$msg_id == 0) {
			$root->mController->executeForward(XOOPS_MODULE_URL . "/pm/pmlite.php");
		}
		else {
			$root->mController->executeForward(XOOPS_MODULE_URL . "/pm/pmlite.php?reply=1&msg_id=" . $msg_id);
		}
	}

}

?>