<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/class/XCube_ActionStrategy.class.php";

define ("LEGACYRENDER_FRAME_PERFORM_SUCCESS", 1);
define ("LEGACYRENDER_FRAME_PERFORM_FAIL", 2);
define ("LEGACYRENDER_FRAME_INIT_SUCCESS", 3);

define ("LEGACYRENDER_FRAME_VIEW_NONE", 1);
define ("LEGACYRENDER_FRAME_VIEW_SUCCESS", 2);
define ("LEGACYRENDER_FRAME_VIEW_ERROR", 3);
define ("LEGACYRENDER_FRAME_VIEW_INDEX", 4);
define ("LEGACYRENDER_FRAME_VIEW_INPUT", 5);
define ("LEGACYRENDER_FRAME_VIEW_PREVIEW", 6);
define ("LEGACYRENDER_FRAME_VIEW_CANCEL", 7);

class LegacyRender_ActionFrame extends XCube_ActionStrategy
{
	var $mActionName = null;
	var $mAction = null;
	var $mAdminFlag = null;

	function LegacyRender_ActionFrame($admin)
	{
		$this->mAdminFlag = $admin;
	}

	function setActionName($name)
	{
		$this->mActionName = $name;
	}

	function execute(&$controller)
	{
		if (!preg_match("/^\w+$/", $this->mActionName)) {
			die();
		}
	
		//
		// Create action object by mActionName
		//
		$className = "LegacyRender_" . ucfirst($this->mActionName) . "Action";
		$fileName = ucfirst($this->mActionName) . "Action";
		if ($this->mAdminFlag) {
			$fileName = XOOPS_MODULE_PATH . "/legacyRender/admin/actions/${fileName}.class.php";
		}
		else {
			$fileName = XOOPS_MODULE_PATH . "/legacyRender/actions/${fileName}.class.php";
		}
	
		if (!file_exists($fileName)) {
			die();
		}
	
		require_once $fileName;
	
		if (class_exists($className)) {
			$this->mAction =& new $className($this->mAdminFlag);
		}
	
		if (!is_object($this->mAction)) {
			die();
		}
		
		$handler =& xoops_gethandler('config');
		$moduleConfig =& $handler->getConfigsByDirname('legacyRender');
	
		$this->mAction->prepare($controller, $controller->getXoopsUser(), $moduleConfig);

		if (!$this->mAction->hasPermission($controller, $controller->getXoopsUser())) {
			if ($this->mAdminFlag) {
				$controller->executeForward(XOOPS_URL . "/admin.php");
			}
			else {
				$controller->executeForward(XOOPS_URL);
			}
		}
	
		if (xoops_getenv("REQUEST_METHOD") == "POST") {
			$viewStatus = $this->mAction->execute($controller, $controller->getXoopsUser());
		}
		else {
			$viewStatus = $this->mAction->getDefaultView($controller, $controller->getXoopsUser());
		}
	
		switch($viewStatus) {
			case LEGACYRENDER_FRAME_VIEW_SUCCESS:
				$this->mAction->executeViewSuccess($controller, $controller->getXoopsUser(), $controller->mModuleController->mRenderTarget);
				break;
		
			case LEGACYRENDER_FRAME_VIEW_ERROR:
				$this->mAction->executeViewError($controller, $controller->getXoopsUser(), $controller->mModuleController->mRenderTarget);
				break;
		
			case LEGACYRENDER_FRAME_VIEW_INDEX:
				$this->mAction->executeViewIndex($controller, $controller->getXoopsUser(), $controller->mModuleController->mRenderTarget);
				break;
		
			case LEGACYRENDER_FRAME_VIEW_INPUT:
				$this->mAction->executeViewInput($controller, $controller->getXoopsUser(), $controller->mModuleController->mRenderTarget);
				break;
		
			case LEGACYRENDER_FRAME_VIEW_PREVIEW:
				$this->mAction->executeViewPreview($controller, $controller->getXoopsUser(), $controller->mModuleController->mRenderTarget);
				break;
		
			case LEGACYRENDER_FRAME_VIEW_CANCEL:
				$this->mAction->executeViewCancel($controller, $controller->getXoopsUser(), $controller->mModuleController->mRenderTarget);
				break;
		}
	}
}

class LegacyRender_Action
{
	/**
	 * @access private
	 */
	var $_mAdminFlag = false;
	
	function LegacyRender_Action($adminFlag = false)
	{
		$this->_mAdminFlag = $adminFlag;
	}

	function hasPermission(&$controller, &$xoopsUser)
	{
		return true;
	}
	
	function prepare(&$controller, &$xoopsUser, $moduleConfig)
	{
	}

	function getDefaultView(&$controller, &$xoopsUser)
	{
		return LEGACYRENDER_FRAME_VIEW_NONE;
	}

	function execute(&$controller, &$xoopsUser)
	{
		return LEGACYRENDER_FRAME_VIEW_NONE;
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewPreview(&$controller, &$xoopsUser, &$render)
	{
	}

	function executeViewCancel(&$controller, &$xoopsUser, &$render)
	{
	}
}

?>
