<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . '/include/comment_constants.php';

class BaseThemeObject extends XoopsSimpleObject
{
	function BaseThemeObject()
	{
		$this->initVar('name', XOBJ_DTYPE_STRING, '', true, 255);
		$this->initVar('dirname', XOBJ_DTYPE_STRING, '', true, 255);
		$this->initVar('screenshot', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('description', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('format', XOBJ_DTYPE_STRING, '', true, 255);
		$this->initVar('render_system', XOBJ_DTYPE_STRING, '', true, 255);
		$this->initVar('version', XOBJ_DTYPE_STRING, '', true, 32);
		$this->initVar('author', XOBJ_DTYPE_STRING, '', true, 64);
		$this->initVar('url', XOBJ_DTYPE_STRING, '', true, 255);
	}
}

class BaseThemeHandler extends XoopsObjectHandler
{
	var $_mResults = array();
	
	/**
	 * @var XCube_Delegate
	 */
	var $mGetInstalledThemes = null;
	
	function BaseThemeHandler(&$db)
	{
		$this->mGetInstalledThemes =& new XCube_Delegate();
		$this->mGetInstalledThemes->register('BaseThemeHandler.GetInstalledThemes');
	}
	
	function &create()
	{
		$ret =& new BaseThemeObject();
		return $ret;
	}
	
	function &get($name)
	{
		$this->_makeCache();
		
		foreach (array_keys($this->_mResults) as $key) {
			if ($this->_mResults[$key]->get('dirname') == $name) {
				return $this->_mResults[$key];
			}
		}
		
		return null;
	}
	
	function &getObjects($criteria = null, $id_as_key = false)
	{
		$this->_makeCache();
		return $this->_mResults;
	}
	
	/**
	 * Create cache at $this->mResult by Delegate, if cache is empty.
	 */
	function _makeCache()
	{
		if (count($this->_mResults) == 0) {
			$t_themeArr = array();
			$this->mGetInstalledThemes->call(new XCube_Ref($t_themeArr));
			
			foreach ($t_themeArr as $theme) {
				$obj =& $this->create();
				$obj->set('name', $theme->mName);
				$obj->set('dirname', $theme->mDirname);
				$obj->set('screenshot', $theme->mScreenShot);
				$obj->set('description', $theme->mDescription);
				$obj->set('format', $theme->mFormat);
				$obj->set('render_system', $theme->mRenderSystemName);
				$obj->set('version', $theme->mVersion);
				$obj->set('author', $theme->mAuthor);
				$obj->set('url', $theme->mUrl);
				$this->_mResults[] =& $obj;
				unset($obj);
			}
		}
	}
	
	function insert(&$obj, $force = false)
	{
		return false;
	}

	function delete(&$obj, $force = false)
	{
		return false;
	}
}

?>
