<?php
/**
 * @package Legacy
 * @version $Id: CommentListAction.class.php,v 1.1.2.8 2006/08/08 09:47:04 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/base/class/PageNavigator.class.php";
require_once XOOPS_MODULE_PATH . "/base/class/AbstractListAction.class.php";
require_once XOOPS_MODULE_PATH . "/base/admin/forms/CommentFilterForm.class.php";

class Legacy_CommentListAction extends Legacy_AbstractListAction
{
	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('comment');
		return $handler;
	}

	function &_getFilterForm(&$navi)
	{
		$filter =& new Legacy_CommentFilterForm($navi);
		return $filter;
	}

	function _getBaseUrl()
	{
		return "./index.php?action=CommentList";
	}

	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
		//
		// Load the module and the comment user infomations.
		//
		foreach (array_keys($this->mObjects) as $key) {
			$this->mObjects[$key]->loadModule();
			$this->mObjects[$key]->loadUser();
			$this->mObjects[$key]->loadStatus();
		}
		
		$moduleArr = array();
		$handler =& xoops_getmodulehandler('comment');
		$modIds =& $handler->getModuleIds();
		
		$moduleHandler =& xoops_gethandler('module');
		foreach ($modIds as $mid) {
			$module =& $moduleHandler->get($mid);
			if (is_object($module)) {
				$moduleArr[] =& $module;
			}
			unset ($module);
		}
		
		$statusArr = array();
		$statusHandler =& xoops_getmodulehandler('commentstatus');
		$statusArr =& $statusHandler->getObjects();
		
		$render->setTemplateName("comment_list.html");
		$render->setAttribute("objects", $this->mObjects);
		$render->setAttribute("pageNavi", $this->mNavi);
		$render->setAttribute("moduleArr", $moduleArr);
		$render->setAttribute("statusArr", $statusArr);
	}
}

?>
