<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/class/XCube_ActionForm.class.php";

/**
 * This class is generated by makeActionForm tool.
 */
class User_AbstractUserEditForm extends XCube_ActionForm
{
	var $mConfig = array();
	
	function prepare($userConfig)
	{
		$this->mConfig = $userConfig;
	}
	
	function validateUname()
	{
		if($this->get('uname')) {
			//
			// uname unique check
			//
			$userHandler=&xoops_gethandler('user');
			$criteria =& new CriteriaCompo(new Criteria('uname', $this->get('uname')));
			if ($this->get('uid')) {
				$criteria->add(new Criteria('uid', $this->get('uid'), '<>'));
			}
			if ($userHandler->getCount($criteria) > 0) {
				$this->addErrorMessage(_US_NICKNAMETAKEN);
			}

			//
			// Check allow uname string pattern.
			//
			$regex="";
			switch($this->mConfig['uname_test_level']) {
				case 0:
					$regex="/[^a-zA-Z0-9\_\-]/";
					break;

				case 1:
					$regex="/[^a-zA-Z0-9\_\-\<\>\,\.\$\%\#\@\!\\\'\"]/";
					break;

				case 2:
					$regex="//[\000-\040]/";
					break;
			}
			if(preg_match($regex,$this->get('uname'))) {
				$this->addErrorMessage(_US_INVALIDNICKNAME);
			}

			//
			// Check bad uname patterns.
			//
			foreach(explode("|",$this->mConfig['bad_unames']) as $pattern) {
				if(!empty($pattern)&&preg_match("/".$pattern."/i",$this->get('uname'))) {
					$this->addErrorMessage(_US_NAMERESERVED);
					break;
				}
			}
		}
	}

	function validateTimezone_offset()
	{
		$handler =& xoops_gethandler('timezone');
		$obj =& $handler->get($this->get('timezone_offset'));
		if (!is_object($obj)) {
			$this->addErrorMessage(_MD_USER_ERROR_TIMEZONE);
		}
	}
	
	function validateEmail()
	{
		if ($this->get('email') != null && !preg_match("/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+([\.][a-z0-9-]+)+$/i",$this->get('email'))) {
			$this->addErrorMessage(_MD_USER_ERROR_EMAIL_FORMAT);
		}
	}
	
	function validatePass()
	{
		if (strlen($this->get('pass'))>0||strlen($this->get('vpass'))>0) {
			if($this->get('pass')!=$this->get('vpass')) {
				$this->addErrorMessage(_MD_USER_ERROR_PASSWORD);
				$this->set('pass',null);	// reset
				$this->set('vpass',null);
			}
		}
	}
}

?>
