<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/user/class/AbstractFilterForm.class.php";

define('AVATAR_SORT_KEY_DEFAULT', 0);
define('AVATAR_SORT_KEY_AVATAR_ID', 1);
define('AVATAR_SORT_KEY_AVATAR_FILE', 2);
define('AVATAR_SORT_KEY_AVATAR_NAME', 3);
define('AVATAR_SORT_KEY_AVATAR_MIMETYPE', 4);
define('AVATAR_SORT_KEY_AVATAR_CREATED', 5);
define('AVATAR_SORT_KEY_AVATAR_DISPLAY', 6);
define('AVATAR_SORT_KEY_AVATAR_WEIGHT', 7);
define('AVATAR_SORT_KEY_AVATAR_TYPE', 8);
define('AVATAR_SORT_KEY_MAXVALUE', 8);

class User_AvatarFilterForm extends User_AbstractFilterForm
{
	var $mSort = 0;
	var $_mSortKeys = array(
		AVATAR_SORT_KEY_DEFAULT => 'avatar_id',
		AVATAR_SORT_KEY_AVATAR_ID => 'avatar_id',
		AVATAR_SORT_KEY_AVATAR_FILE => 'avatar_file',
		AVATAR_SORT_KEY_AVATAR_NAME => 'avatar_name',
		AVATAR_SORT_KEY_AVATAR_MIMETYPE => 'avatar_mimetype',
		AVATAR_SORT_KEY_AVATAR_CREATED => 'avatar_created',
		AVATAR_SORT_KEY_AVATAR_DISPLAY => 'avatar_display',
		AVATAR_SORT_KEY_AVATAR_WEIGHT => 'avatar_weight',
		AVATAR_SORT_KEY_AVATAR_TYPE => 'avatar_type'
	);
	var $_mCriteria = null;

	function fetch()
	{
		$this->mSort = isset($_REQUEST['sort']) ? intval($_REQUEST['sort']) : 0;
	
		if ($this->mSort > AVATAR_SORT_KEY_MAXVALUE) {
			$this->mSort = AVATAR_SORT_KEY_DEFAULT;
		}
	
		if (isset($_REQUEST['avatar_id'])) {
			$this->_mCriteria->add(new Criteria('avatar_id', array(XOBJ_DTYPE_INT, xoops_getrequest('avatar_id'))));
		}
	
		if (isset($_REQUEST['avatar_file'])) {
			$this->_mCriteria->add(new Criteria('avatar_file', array(XOBJ_DTYPE_STRING, xoops_getrequest('avatar_file'))));
		}
	
		if (isset($_REQUEST['avatar_name'])) {
			$this->_mCriteria->add(new Criteria('avatar_name', array(XOBJ_DTYPE_STRING, xoops_getrequest('avatar_name'))));
		}
	
		if (isset($_REQUEST['avatar_mimetype'])) {
			$this->_mCriteria->add(new Criteria('avatar_mimetype', array(XOBJ_DTYPE_STRING, xoops_getrequest('avatar_mimetype'))));
		}
	
		if (isset($_REQUEST['avatar_created'])) {
			$this->_mCriteria->add(new Criteria('avatar_created', array(XOBJ_DTYPE_INT, xoops_getrequest('avatar_created'))));
		}
	
		if (isset($_REQUEST['avatar_display'])) {
			$this->_mCriteria->add(new Criteria('avatar_display', array(XOBJ_DTYPE_BOOL, xoops_getrequest('avatar_display'))));
		}
	
		if (isset($_REQUEST['avatar_weight'])) {
			$this->_mCriteria->add(new Criteria('avatar_weight', array(XOBJ_DTYPE_INT, xoops_getrequest('avatar_weight'))));
		}
	
		if (isset($_REQUEST['avatar_type'])) {
			$this->_mCriteria->add(new Criteria('avatar_type', array(XOBJ_DTYPE_STRING, xoops_getrequest('avatar_type'))));
		}
	}
}

?>
