<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/user/admin/forms/UserSearchForm.class.php";

class User_UserSearchAction extends User_Action
{
	var $mActionForm = null;
	
	function prepare(&$controller, &$xoopsUser)
	{
		$this->mActionForm =& new User_UserSearchForm();
		$this->mActionForm->prepare();
	}
	
	function getDefaultView(&$controller, &$xoopsUser)
	{
		$this->mActionForm->fetch();
		
		return USER_FRAME_VIEW_INPUT;
	}
	
	function execute(&$controller, &$xoopsUser)
	{
		$this->mActionForm->fetch();
		$this->mActionForm->validate();
		
		if ($this->mActionForm->hasError()) {
			return $this->getDefaultView();
		}
		
		return USER_FRAME_VIEW_SUCCESS;
	}
	
	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("user_search.html");
		$render->setAttribute("actionForm", $this->mActionForm);
	}

	function executeViewSuccess(&$controller,&$xoopsUser,&$renderSystem)
	{
		$controller->executeForward("./index.php?action=UserSearchList");
	}

	function executeViewError(&$controller,&$xoopsUser,&$renderSystem)
	{
		XCube_Utils::redirectHeader("index.php", 1, "*ERROR*");
	}
}

?>