<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/user/class/AbstractDeleteAction.class.php";
require_once XOOPS_MODULE_PATH . "/user/admin/forms/RanksAdminDeleteForm.class.php";

class User_RanksDeleteAction extends User_AbstractDeleteAction
{
	function _getId()
	{
		return isset($_REQUEST['rank_id']) ? $_REQUEST['rank_id'] : 0;
	}

	function &_getHandler()
	{
		$handler =& xoops_getmodulehandler('ranks');
		return $handler;
	}

	function _setupActionForm()
	{
		$this->mActionForm =& new RanksAdminDeleteForm();
		$this->mActionForm->prepare();
	}

	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("ranks_delete.html");
		$render->setAttribute('actionForm', $this->mActionForm);
		$render->setAttribute('object', $this->mObject);
	}

	function executeViewSuccess(&$controller, &$xoopsUser, &$render)
	{
		$controller->executeForward("./index.php?action=RanksList");
	}

	function executeViewError(&$controller, &$xoopsUser, &$render)
	{
		redirect_header("./index.php?action=RanksList", 1, _AD_USER_ERROR_DBUPDATE_FAILED);
	}
}

?>
