<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH."/class/XCube_ActionForm.class.php";

/**
 * This class is generated by makeActionForm tool.
 * 
 * This class was generated in the old days. We should to check it.
 * 
 * @auchor makeActionForm
 * @abstract
 */
class PmliteEditForm extends XCube_ActionForm 
{
	var $mState=null;
	
	function getTokenName()
	{
		return "module.user.PmliteEditForm.TOKEN";
	}

	function prepare()
	{
		$this->mFormProperties['subject']=new XCube_StringProperty('subject');
		$this->mFormProperties['message']=new XCube_TextProperty('message');

		// set fields
		$this->mFieldProperties['subject']=new XCube_FieldProperty($this);
		$this->mFieldProperties['subject']->setDependsByArray(array('required'));
		$this->mFieldProperties['subject']->addMessage("required",_MD_PM_ERROR_REQUIRED,_PM_SUBJECT);

		$this->mFieldProperties['message']=new XCube_FieldProperty($this);
		$this->mFieldProperties['message']->setDependsByArray(array('required'));
		$this->mFieldProperties['message']->addMessage("required",_MD_PM_ERROR_REQUIRED,_MD_PM_LANG_MESSAGE);

		if(is_object($this->mState))
			$this->mState->prepare($this);
	}
	
	function fetch()
	{
		parent::fetch();

		if(is_object($this->mState))
			$this->mState->fetch($this);
	}

	function changeStateReply()
	{
		$this->mState=new PmliteEditFormReplyState();
	}

	function setToUser(&$user)
	{
	}

	function resetToUser()
	{
	}
}

class PmliteComboEditForm extends PmliteEditForm
{
	function prepare()
	{
		parent::prepare();
		$this->mFormProperties['to_userid']=new XCube_IntProperty('to_userid');
	}

	/**
	 * Check existence of the target user.
	 */
	function validateTo_userid()
	{
		if($this->get('to_userid')) {
			$userHandler=&xoops_gethandler('user');
			$user=&$userHandler->get($this->get('to_userid'));

			if(!(is_object($user)&&$user->isActive())) {
				$this->set('to_userid',0);
				$this->addErrorMessage(_PM_USERNOEXIST);
			}
		}
	}

	/**
	 * @param $pm PrivateMessage
	 */
	function update(&$pm)
	{
		$userHandler=&xoops_gethandler('user');
		$toUser=&$userHandler->get($this->get('to_userid'));
		$pm->setToUsers($toUser);
		$pm->setSubject($this->get("subject"));
		$pm->setMessage($this->get("message"));
	}

	function setToUser(&$user)
	{
		$this->set('to_userid',$user->get('uid'));
	}
	
	function resetToUser()
	{
		$this->set('to_userid',0);
	}
}

class PmliteDirectEditForm extends PmliteEditForm
{
	var $mToUser;

	function prepare()
	{
		parent::prepare();
		$this->mFormProperties['to_uname']=new XCube_StringProperty('to_uname');
	}

	/**
	 * Check existence of the target user.
	 */
	function validateTo_uname()
	{
		if($this->get('to_uname')) {
			$userHandler=&xoops_gethandler('user');
			$criteria=new Criteria("uname",$this->get("to_uname"));
			$users=&$userHandler->getObjects($criteria);

			if(!(count($users)>0 && is_object($users[0]) && $users[0]->isActive())) {
				$this->addErrorMessage(_PM_USERNOEXIST);
			}
			
			$this->mToUser=&$users[0];
		}
	}

	/**
	 * @param $pm PrivateMessage
	 */
	function update(&$pm)
	{
		$pm->setToUsers($this->mToUser);
		$pm->setSubject($this->get("subject"));
		$pm->setMessage($this->get("message"));
	}

	function setToUser(&$user)
	{
		$this->set('to_uname',$user->get('uname'));
	}

	function resetToUser()
	{
		$this->set('to_uname',"");
	}
}

/**
 * This shows reply-mode for ActionForm of pmlite.
 */
class PmliteEditFormReplyState
{
	/**
	 * @param $form PmliteEditForm
	 */
	function prepare(&$form)
	{
		$form->mFormProperties['msg_id']=new XCube_IntProperty('msg_id');
	}

	/**
	 * @param $form PmliteEditForm
	 */
	function fetch(&$form)
	{
		if($form->get('msg_id')) {
			$pmHandler=&xoops_gethandler('privmessage');
			$pm=&$pmHandler->get($form->get('msg_id'));
			if(is_object($pm)) {
				$root=XCube_Root::getSingleton();
				$currentUser=&$root->mController->getXoopsUser();
				if($pm->get('to_userid')==$currentUser->get('uid')) {
					if(!preg_match("/^Re:/",$pm->get('subject')))
						$form->set('subject',"Re: ".$pm->get('subject'));

					// TODO Use Active Check
					$userHandler=&xoops_gethandler('user');
					$user=&$userHandler->get($pm->get('from_userid'));

					$form->setToUser($user);
					$message="[quote]\n";
					$message.=sprintf(_PM_USERWROTE,$user->get('uname')) . "\n";
					$message.=$pm->getProperty("msg_text") . "\n";
					$message.="[/quote]\n";
					$form->set("message",$message);
					
					return;
				}
			}
		}

		//
		// Reset
		//
		$form->set('msg_id',0);
		$form->resetToUser();
	}
}

?>
