<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

define('TPLSET_SORT_KEY_DEFAULT', 0);
define('TPLSET_SORT_KEY_TPLSET_ID', 1);
define('TPLSET_SORT_KEY_NAME', 2);
define('TPLSET_SORT_KEY_DESC', 3);
define('TPLSET_SORT_KEY_LOCK', 4);
define('TPLSET_SORT_KEY_MAXVALUE', 4);

class LegacyRender_TplsetFilterForm
{
	var $mSort = 0;
	var $_mSortKeys = array(
		TPLSET_SORT_KEY_DEFAULT => 'tplset_id',
		TPLSET_SORT_KEY_TPLSET_ID => 'tplset_id',
		TPLSET_SORT_KEY_NAME => 'name',
		TPLSET_SORT_KEY_DESC => 'desc',
		TPLSET_SORT_KEY_LOCK => 'lock'
	);
	var $_mCriteria = null;
	
	var $_mNavi = null;

	function LegacyRender_TplsetFilterForm(&$navi)
	{
		$this->_mNavi =& $navi;
		$this->_mCriteria =& new CriteriaCompo();
	}

	function fetch()
	{
		$this->mSort = isset($_REQUEST['sort']) ? intval($_REQUEST['sort']) : 0;
	
		if (abs($this->mSort) > TPLSET_SORT_KEY_MAXVALUE) {
			$this->mSort = TPLSET_SORT_KEY_DEFAULT;
		}

		$this->_mNavi->addExtra('sort', $this->mSort);
	}

	function getSort()
	{
		$sortkey = abs($this->mSort);
		return $this->_mSortKeys[$sortkey];
	}

	function getOrder()
	{
		return ($this->mSort < 0) ? "DESC" : "ASC";
	}

	function getCriteria($start = 0, $limit = 0)
	{
		$criteria = $this->_mCriteria;
	
		$criteria->setStart($start);
		$criteria->setLimit($limit);
	
		$criteria->setSort($this->getSort());
		$criteria->setOrder($this->getOrder());
	
		return $criteria;
	}
}

?>
