<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_BASE_PATH."/admin/class/AbstractModuleInstaller.class.php";

class Legacy_ModuleUpdater extends Legacy_AbstractModuleInstaller
{
	var $mPreVersion = 0;

	/**
	 * @return bool
	 */
	function execute()
	{
		$this->mLog->addReport("Update started");
		
		parent::execute();
	}
	
	/**
	 * Load xoops module object installed and return it.
	 * @static
	 * @access public
	 * @param $dirname string
	 * @return XoopsModule
	 */
	function &loadModuleObject($dirname)
	{
		$ret = null;

		$moduleHandler =& xoops_gethandler('module');
		$module =& $moduleHandler->getByDirname($dirname);

		if (!is_object($module))
			return $ret;

		$this->mPreVersion = $module->getVar('version');

		$module->loadInfoAsVar($dirname);
		
		return $module;
	}

	/**
	 * Remove all of installed templates and re-install all of defined templates.
	 */
	function _installTemplate()
	{
		$tplHandler =& xoops_gethandler('tplfile');

		//
		// The following processing depends on the structure of Legacy_RenderSystem.
		//
		$tplHandler =& xoops_gethandler('tplfile');
		$delTemplates =& $tplHandler->find('default', 'module', $this->mModule->getVar('mid'));
		if(is_array($delTemplates) && count($delTemplates) > 0) {
			//
			// clear cache
			//
			$xoopsTpl=new XoopsTpl();
			$xoopsTpl->clear_cache(null, "mod_" . $this->mModule->getVar('dirname'));
			
			foreach ($delTemplates as $tpl) {
				if (!$tplHandler->delete($tpl)) {
					$this->mLog->addError(@sprintf(_MD_A_BASE_ERROR_DELETE_TEMPLATE, $tpl->getVar('tpl_file')));
				}
			}
		}

		//
		// install Template All
		//
		$templates = $this->mModule->getInfo('templates');
		if ($templates != false) {
			foreach ($templates as $template) {
				Legacy_ModuleUtils::installTemplate($this->mModule, $template, $this->mLog);
			}
		}
	}

	/**
	 * @return bool
	 */
	function _installBlock()
	{
		// XoopsBlock[]
		$installBlocks = array();

		// XoopsBlock[]
		$unInstallBlocks = array();

		$definedBlocks = $this->mModule->getInfo('blocks');
		if($definedBlocks == false)
			return false;

		$blockHandler =& xoops_gethandler('block');

		$func_num=0;
		foreach ($definedBlocks as $block) {
			$func_num++;
			$newBlock =& Legacy_ModuleUtils::createBlockByInfo($this->mModule, $block);

			//
			// Get a installed block by mid and name.
			//
			$criteria = new CriteriaCompo();
			$criteria->add(new Criteria('mid', $this->mModule->getVar('mid')));
			$criteria->add(new Criteria('name', $block['name']));
			$installedBlocks =& $blockHandler->getObjectsDirectly($criteria);

			//
			// If a installed block is not found, push it to new install block list.
			//
			if (count($installedBlocks) == 0) {
				$newBlock->setVar('func_num', $func_num);
				$installBlocks[] = array($newBlock, $block);
				unset($newBlock);

				continue;
			}

			$changedFlag = false;

			$oldBlock =& $installedBlocks[0];
            $newBlock =& Legacy_ModuleUtils::mergeBlockObject($oldBlock, $newBlock, $changedFlag);

			if ($changedFlag) {
				$installBlocks[] = array($newBlock, $block);
			}
			else {
				if (!Legacy_ModuleUtils::installBlockTemplate($this->mModule, $oldBlock)) {
					$this->mLog->addError("ERROR : Could not update block template ".$oldBlock->getVar('name'));
				}
			}

			unset($newBlock);
			unset($oldBlock);
		}

		$criteria = new CriteriaCompo();
		$criteria->add(new Criteria('mid', $this->mModule->getVar('mid')));
		$installedBlocks =& $blockHandler->getObjectsDirectly($criteria);
		foreach ($installedBlocks as $blockObj) {
			$name = $blockObj->getVar('name');
			$findFlag = false;
			foreach ($definedBlocks as $definedBlock) {
				$findFlag |= ($definedBlock['name'] == $blockObj->getVar('name'));
			}

			if (!$findFlag) {
				$unInstallBlocks[] =& $blockObj;
				unset($blockObj);
			}
		}

		foreach ($installBlocks as $block) {
			Legacy_ModuleUtils::installBlock($this->mModule, $block[0], $block[1], $this->mLog);
		}

		/*
		foreach ($unInstallBlocks as $block) {
			Legacy_ModuleUtils::unInstallBlock($block);
		}
		*/
	}
	
	function _installPreference()
	{
		Legacy_ModuleUtils::deleteAllConfigs($this->mModule, $this->mLog);
		Legacy_ModuleUtils::insertAllConfigs($this->mModule, $this->mLog);
	}

	function _processScript()
	{
		$installScript = trim($this->mModule->getInfo('onUpdate'));
		if ($installScript != false) {
			require_once XOOPS_MODULE_PATH . "/" . $this->mModule->getVar('dirname') . "/" . $installScript;
			$funcName = 'xoops_module_update_' . $this->mModule->getVar('dirname');
			if (function_exists($funcName)) {
				if (!call_user_func($funcName, $this->mModule, $this->mPreVersion)) {
					$this->mLog->addError("Failed to execute " . $funcName);
				}
			}
		}
	}
}

?>