<?php
/**
 * @version $Id: ModuleListAction.class.php,v 1.1.2.5 2006/03/28 13:28:35 minahito Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_BASE_PATH . "/admin/forms/ModuleListFilterForm.class.php";
require_once XOOPS_BASE_PATH . "/admin/forms/ModuleListForm.class.php";

class Legacy_ModuleListAction extends Legacy_Action
{
	var $mDB = null;
	var $mModuleObjects = array();
	var $mFilter = null;

	var $mActionForm = null;

	function prepare(&$controller, &$xoopsUser)
	{
		$this->mDB =& $controller->getDB();
		
		$this->mActionForm =& new Legacy_ModuleListForm();
		$this->mActionForm->prepare();
	}
	

	function getDefaultView(&$controller, &$xoopsUser)
	{
		$this->mFilter =& new ModuleListFilterForm();
		$this->mFilter->fetch();
		
		$moduleHandler =& xoops_gethandler('module');

		// dmy
		$criteria =& new Criteria('mid',0,'>');
		$criteria->setSort($this->mFilter->getSort());
		$criteria->setOrder($this->mFilter->getOrder());
		
		$this->mModuleObjects =& $moduleHandler->getObjects($criteria);

		return LEGACY_FRAME_VIEW_INDEX;
	}
	
	function execute(&$controller, &$xoopsUser)
	{
		$this->mActionForm->fetch();
		$this->mActionForm->validate();

		if ($this->mActionForm->hasError()) {
			return $this->_processConfirm($controller, $xoopsUser);
		}
		else {
			return $this->_processSave($controller, $xoopsUser);
		}
	}
	
	function _processConfirm(&$controller,&$xoopsUser)
	{
		$moduleHandler =& xoops_gethandler('module');
		$objects =& $moduleHandler->getObjects();

		//
		// Do mapping.
		//
		foreach ($objects as $modObject) {
			$this->mModuleObjects[$modObject->get('mid')] =& $modObject;
			unset($modObject);
		}

		return LEGACY_FRAME_VIEW_INPUT;
	}

	function _processSave(&$controller, &$xoopsUser)
	{
		$moduleHandler =& xoops_gethandler('module');
		$objects =& $moduleHandler->getObjects();
		
		$successFlag = true;
		foreach($objects as $modObject) {
			$mid = $modObject->get('mid');
			$modObject->set('name', $this->mActionForm->get('name', $mid));
			$modObject->set('weight', $this->mActionForm->get('weight', $mid));
			$modObject->set('isactive', $this->mActionForm->get('isactive', $mid));

			//
			// Store.
			//
			$successFlag &= $moduleHandler->insert($modObject);
		}
		
		return $successFlag ? LEGACY_FRAME_VIEW_SUCCESS : LEGACY_FRAME_VIEW_ERROR;
	}

	/**
	 * To support a template writer, this send the list of mid that actionForm kept.
	 */
	function executeViewInput(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("module_list_confirm.html");
		$render->setAttribute('moduleObjects', $this->mModuleObjects);
		$render->setAttribute('actionForm', $this->mActionForm);
		
		//
		// To support a template writer, this send the list of mid that
		// actionForm kept.
		//
		$tarray=&$this->mActionForm->get('name');
		$render->setAttribute('mids', array_keys($tarray));
	}

	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName("module_list.html");
		$render->setAttribute('actionForm', $this->mActionForm);

		//
		// Load adminmenu before we assign these to template.
		//
		foreach(array_keys($this->mModuleObjects) as $key) {
			$this->mModuleObjects[$key]->loadAdminMenu();
			$this->mModuleObjects[$key]->loadInfo($this->mModuleObjects[$key]->get('dirname'));
		}
		$render->setAttribute('moduleObjects', $this->mModuleObjects);
	}

	function executeViewSuccess(&$controller,&$xoopsUser,&$renderer)
	{
		$controller->executeForward('./index.php?action=ModuleList');
	}

	function executeViewError(&$controller, &$xoopsUser, &$renderer)
	{
		//
		// TODO removed
		//
		XCube_Utils::redirectHeader('./index.php?action=ModuleList', 1, "*ERROR*");
	}
}

?>