<?php
/**
 * @version $Id: XCube_RenderSystem.class.php,v 1.1.2.14 2006/03/28 13:28:16 minahito Exp $
 * @package Cube
 */

 if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/kernel/XCube_TextModifier.class.php";

define("XCUBE_RENDER_MODE_NORMAL",1);
define("XCUBE_RENDER_MODE_DIALOG",2);

/**
 * We had to define classes that are XCube_RenderTargetBuffer, XCube_RenderTargetTheme,
 * XCube_RenderTargetBlock and XCube_RenderTargetMain. And, a render-system had
 * to define render-sub-system that renders to these render-target. However, this
 * style gives a heavy load to our XOOPS Cube system that is a PHP application.
 *
 * We prepare the following constants for the flag of a render-target instead of
 * the group of many classes. 
 */
define("XCUBE_RENDER_TARGET_TYPE_BUFFER",0);
define("XCUBE_RENDER_TARGET_TYPE_THEME",1);
define("XCUBE_RENDER_TARGET_TYPE_BLOCK",2);
define("XCUBE_RENDER_TARGET_TYPE_MAIN",3);

/**
 * This is a target whom a render-system renders. This has a buffer and receives
 * a result of a render-system to the buffer. A developer can control rendering
 * with using this class.
 */
class XCube_RenderTarget
{
	var $mName=null;

	var $mRenderBuffer=null;
	
	var $mModuleName = null;
	
	var $mTemplateName=null;

	var $mAttributes = array();
	
	var $mType = XCUBE_RENDER_TARGET_TYPE_BUFFER;
	
	var $mCacheTime = null;
		
	function XCube_RenderTarget()
	{
	}

	function setName($name)
	{
		$this->mName = $name;
	}

	function getName()
	{
		return $this->mName;
	}
	
	function setModuleName($name)
	{
		$this->mModuleName = $name;
	}
	
	function getModuleName()
	{
		return $this->mModuleName;
	}

	function setTemplateName($name)
	{
		$this->mTemplateName = $name;
	}

	function getTemplateName()
	{
		return $this->mTemplateName;
	}
	
	function setAttribute($key,$value)
	{
		$this->mAttributes[$key] = $value;
	}
	
	function setAttributes($attr)
	{
		$this->mAttributes = $attr;
	}
	
	function getAttribute($key)
	{
		return $this->mAttributes[$key];
	}

	function getAttributes()
	{
		return $this->mAttributes;
	}
	
	function setRenderBuffer($buf)
	{
		$this->mRenderBuffer = $buf;
	}
	
	function getRenderBuffer($buf)
	{
		return $this->mRenderBuffer;
	}
	
	function setResult(&$result)
	{
		$this->mRenderBuffer = $result;
	}
	
	function getResult()
	{
		return $this->mRenderBuffer;
	}
	
	/**
	 * Set render-target type.
	 * @param $type int Use constants that are defined by us.
	 */
	function setType($type)
	{
		$this->mType = $type;
	}
	
	/**
	 * Return render-target type.
	 * @return int
	 */
	function getType()
	{
		return $this->mType;
	}
	
	/**
	 * Reset a template name and attributes in own properties.
	 */
	function reset()
	{
		$this->setTemplateName(null);
		$this->setModuleName(null);
		unset($this->mAttributes);
		$this->mAttributes = array();
		$this->mRenderBuffer = null;
	}
}

/**
 * This system is in charge of rendering and contents cache management.
 * For cache management, this system must talk with a business logic before business logic executes.
 * This class has a bad design so that the template engine is strongly tied to cache management.
 * We must divide this class into renderer and cache management.
 */
class XCube_RenderSystem
{
	/**
	 @access private
	 */
	var $mController;

	/**
	 @access private
	 */
	var $mThemeName;
	
	var $mTemplateName;
	
	var $mDisplayThemeFlag=true;

	var $mRenderMode=XCUBE_RENDER_MODE_NORMAL;
	
	/**
	 * This is default whom this renders without the render-target specified.
	 *
	 * @access private
	 */
	var $mRenderTarget=null;
	
	function XCube_RenderSystem()
	{
	}
	
	function prepare()
	{
	}
	
	/**
	 * Set main render target.
	 *
	 * @param $renderTarget XCube_RenderTarget
	 */
	function setRenderTarget(&$renderTarget)
	{
		$this->mRenderTarget=&$renderTarget;
	}

	/**
	 * Return main render target.
	 *
	 * @return XCube_RenderTarget
	 */
	function &getRenderTarget()
	{
		return $this->mRenderTarget;
	}

	function setTemplateName($name)
	{
		$this->mTemplateName=$name;
	}
	
	function setAttribute($key,$value)
	{
	}

	function getAttribute($key)
	{
	}
	
	/**
	 * @deprecated
	 */
	function setThemeName($name)
	{
		$this->mThemeName=$name;
	}
	
	/**
	 * @deprecated
	 */
	function getThemeName($name)
	{
		$this->mThemeName=$name;
	}

	function renderBlock(&$blockProcedure)
	{
	}
	
	function render()
	{
		$this->renderWithTarget($this->mRenderTarget);
	}
	
	function renderWithTarget(&$renderTarget)
	{
	}

	/**
	 * If you set false, the render system may don't display the theme that have 3 columns layout.
	 * However, XOOPS Cube don't force sub-class to implement this feature.
	 * There is this feature for compatibility with XOOPS 2.0.x.
	 * Base_LegacyRenderSystem will implement this feature.
	 * @param $flag bool
	 */
	function setDisplayTheme($flag)
	{
		$this->mDisplayThemeFlag=$flag;
	}
	
	/**
	 * @deprecated 
	 */
	function renderMessageBox(&$messageBox)
	{
		return null;
	}

	/**
	 * @deprecated 
	 */
	function renderConfirmBox(&$messageBox)
	{
		return null;
	}
}

?>