<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_MODULE_PATH . "/user/class/AbstractFilterForm.class.php";
require_once XOOPS_MODULE_PATH . "/user/admin/forms/UserSearchForm.class.php";

define('USER_SORT_KEY_UID', 1);
define('USER_SORT_KEY_NAME', 2);
define('USER_SORT_KEY_UNAME', 3);
define('USER_SORT_KEY_EMAIL', 4);
define('USER_SORT_KEY_URL', 5);
define('USER_SORT_KEY_USER_AVATAR', 6);
define('USER_SORT_KEY_USER_REGDATE', 7);
define('USER_SORT_KEY_USER_ICQ', 8);
define('USER_SORT_KEY_USER_FROM', 9);
define('USER_SORT_KEY_USER_SIG', 10);
define('USER_SORT_KEY_USER_VIEWEMAIL', 11);
define('USER_SORT_KEY_ACTKEY', 12);
define('USER_SORT_KEY_USER_AIM', 13);
define('USER_SORT_KEY_USER_YIM', 14);
define('USER_SORT_KEY_USER_MSNM', 15);
define('USER_SORT_KEY_PASS', 16);
define('USER_SORT_KEY_POSTS', 17);
define('USER_SORT_KEY_ATTACHSIG', 18);
define('USER_SORT_KEY_RANK', 19);
define('USER_SORT_KEY_LEVEL', 20);
define('USER_SORT_KEY_THEME', 21);
define('USER_SORT_KEY_TIMEZONE_OFFSET', 22);
define('USER_SORT_KEY_LAST_LOGIN', 23);
define('USER_SORT_KEY_UMODE', 24);
define('USER_SORT_KEY_UORDER', 25);
define('USER_SORT_KEY_NOTIFY_METHOD', 26);
define('USER_SORT_KEY_NOTIFY_MODE', 27);
define('USER_SORT_KEY_USER_OCC', 28);
define('USER_SORT_KEY_BIO', 29);
define('USER_SORT_KEY_USER_INTREST', 30);
define('USER_SORT_KEY_USER_MAILOK', 31);
define('USER_SORT_KEY_MAXVALUE', 31);

define('USER_SORT_KEY_DEFAULT', USER_SORT_KEY_UID);

class User_UserSearchFilterForm extends User_AbstractFilterForm
{
	var $mSort = 0;
	var $_mSortKeys = array(
		USER_SORT_KEY_UID => 'uid',
		USER_SORT_KEY_NAME => 'name',
		USER_SORT_KEY_UNAME => 'uname',
		USER_SORT_KEY_EMAIL => 'email',
		USER_SORT_KEY_URL => 'url',
		USER_SORT_KEY_USER_AVATAR => 'user_avatar',
		USER_SORT_KEY_USER_REGDATE => 'user_regdate',
		USER_SORT_KEY_USER_ICQ => 'user_icq',
		USER_SORT_KEY_USER_FROM => 'user_from',
		USER_SORT_KEY_USER_SIG => 'user_sig',
		USER_SORT_KEY_USER_VIEWEMAIL => 'user_viewemail',
		USER_SORT_KEY_ACTKEY => 'actkey',
		USER_SORT_KEY_USER_AIM => 'user_aim',
		USER_SORT_KEY_USER_YIM => 'user_yim',
		USER_SORT_KEY_USER_MSNM => 'user_msnm',
		USER_SORT_KEY_PASS => 'pass',
		USER_SORT_KEY_POSTS => 'posts',
		USER_SORT_KEY_ATTACHSIG => 'attachsig',
		USER_SORT_KEY_RANK => 'rank',
		USER_SORT_KEY_LEVEL => 'level',
		USER_SORT_KEY_THEME => 'theme',
		USER_SORT_KEY_TIMEZONE_OFFSET => 'timezone_offset',
		USER_SORT_KEY_LAST_LOGIN => 'last_login',
		USER_SORT_KEY_UMODE => 'umode',
		USER_SORT_KEY_UORDER => 'uorder',
		USER_SORT_KEY_NOTIFY_METHOD => 'notify_method',
		USER_SORT_KEY_NOTIFY_MODE => 'notify_mode',
		USER_SORT_KEY_USER_OCC => 'user_occ',
		USER_SORT_KEY_BIO => 'bio',
		USER_SORT_KEY_USER_INTREST => 'user_intrest',
		USER_SORT_KEY_USER_MAILOK => 'user_mailok'
	);
	var $_mCriteria = null;

	var $_mMatchFields = array ("uname", "name", "email", "user_icq", "user_aim", "user_yim", "user_msnm",
	                            "url", "user_from", "user_occ", "user_intrest");
	
	function fetch()
	{
		$this->mSort = isset($_REQUEST['sort']) ? intval($_REQUEST['sort']) : USER_SORT_KEY_DEFAULT;
	
		if ($this->mSort > USER_SORT_KEY_MAXVALUE) {
			$this->mSort = USER_SORT_KEY_DEFAULT;
		}

		$form =& new User_UserSearchForm();
		$form->prepare();

		$form->fetch();
		$form->validate();
		
		if ($form->hasError()) {
			return;
		}
		
		foreach ($this->_mMatchFields as $field) {
			if (strlen($form->get($field)) > 0) {
				$this->mNavi->addExtra($field, $form->get($field));
				$this->_mCriteria->add(new Criteria($field, '%' . $form->get($field) . '%', 'LIKE'));
			}
		}
		
		$this->mNavi->addExtra('mail_condition', $form->get('mail_condition'));
		switch ($form->get('mail_condition')) {
			case 1:
				$this->_mCriteria->add(new Criteria('user_mailok', 1));
				break;
				
			case 2:
				$this->_mCriteria->add(new Criteria('user_mailok', 0));
				break;
		}

		$this->mNavi->addExtra('user_level', $form->get('user_level'));
		switch ($form->get('user_level')) {
			case 1:
				$this->_mCriteria->add(new Criteria('level', 0, '>'));
				break;
				
			case 2:
				$this->_mCriteria->add(new Criteria('level', 0));
				break;
		}
		
		if (strlen($form->get('over_posts')) > 0) {
			$this->mNavi->addExtra('over_posts', $form->get('over_posts'));
			$this->_mCriteria->add(new Criteria('posts', $form->get('over_posts'), '>='));
		}

		if (strlen($form->get('under_posts')) > 0) {
			$this->mNavi->addExtra('under_posts', $form->get('under_posts'));
			$this->_mCriteria->add(new Criteria('posts', $form->get('under_posts'), '<='));
		}

		if (strlen($form->get('lastlog_more')) > 0) {
			$this->mNavi->addExtra('lastlog_more', $form->get('lastlog_more'));
			$time = time() - $form->get('lastlog_more') * 86400;
			$this->_mCriteria->add(new Criteria('last_login', $time, '<='));
		}

		if (strlen($form->get('lastlog_less')) > 0) {
			$this->mNavi->addExtra('lastlog_less', $form->get('lastlog_less'));
			$time = time() - $form->get('lastlog_more') * 86400;
			$this->_mCriteria->add(new Criteria('last_login', $time, '>='));
		}

		if (strlen($form->get('regdate_more')) > 0) {
			$this->mNavi->addExtra('regdate_more', $form->get('regdate_more'));
			$time = time() - $form->get('regdate_more') * 86400;
			$this->_mCriteria->add(new Criteria('user_regdate', $time, '<='));
		}

		if (strlen($form->get('regdate_less')) > 0) {
			$this->mNavi->addExtra('regdate_less', $form->get('regdate_less'));
			$time = time() - $form->get('regdate_less') * 86400;
			$this->_mCriteria->add(new Criteria('user_regdate', $time, '>='));
		}
	}
}

?>
