<?php
// $Id: ThemeSelect.class.php,v 1.1.2.5 2006/03/28 13:30:34 minahito Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

if (!defined('XOOPS_ROOT_PATH')) exit();

class ThemeSelect_Filter extends XCube_ActionFilter
{
	function preBlockFilter()
	{
		if (!empty($_POST['xoops_theme_select']) && in_array($_POST['xoops_theme_select'], $this->mController->mConfig['theme_set_allowed'])) {
			$this->mController->mConfig['theme_set'] = $_POST['xoops_theme_select'];
			$_SESSION['xoopsUserTheme'] = $_POST['xoops_theme_select'];
		} elseif (!empty($_SESSION['xoopsUserTheme']) && in_array($_SESSION['xoopsUserTheme'], $this->mController->mConfig['theme_set_allowed'])) {
			$this->mController->mConfig['theme_set'] = $_SESSION['xoopsUserTheme'];
		}

		$delegate=new XCube_Delegate("ThemeSelect_Filter","callbackCheckLoginSuccess");
		$this->mController->mRoot->mEventManager->add("Site.CheckLogin.Success",$delegate);
	}

	function callbackCheckLoginSuccess(&$controller,&$eventArgs)
	{
		//
		// This check is not needed. :)
		//
		if(!is_object($eventArgs['xoopsUser']))
			return;

		$user=&$eventArgs['xoopsUser'];

		//
		// Check Theme and set it to session.
		//
		$userTheme=$eventArgs['xoopsUser']->getVar('theme');
		if(is_array($userTheme) && in_array($userTheme,$controller->getConfig('theme_set_allowed'))) {
			$_SESSION['xoopsUserTheme'] = $userTheme;
		}
	}
}

?>