<?php
// $Id: Legacy_LanguageManager.class.php,v 1.1.2.5 2006/03/28 13:30:15 minahito Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . "/class/XCube_LanguageManager.class.php";

class Legacy_LanguageManager extends XCube_LanguageManager
{
	var $mLanguageName;

	function loadMainLanguage()
	{
		if (!$this->_loadFile(XOOPS_ROOT_PATH . "/modules/base/language/" . $this->mLanguageName . "/global.php")) {
			$this->_loadFile(XOOPS_ROOT_PATH."/modules/base/language/english/global.php");
		}

		// Now, if XOOPS_USE_MULTIBYTES isn't defined, set zero to it.
		if (!defined("XOOPS_USE_MULTIBYTES")) {
			define("XOOPS_USE_MULTIBYTES",0);
		}
	}

	function loadSpecialTypeLanguage($type)
	{
		if (strpos($type,'.') === false) {
			$filename = XOOPS_ROOT_PATH . "/language/" . $this->mLanguageName . "/" . $type . ".php";
			if (!$this->_loadFile($filename)) {
				$filename = XOOPS_ROOT_PATH . "/language/english/" . $type . ".php";
				$this->_loadFile($filename);
			}
		}
	}

	/**
	 Load language for module controller.
	 @param $dirname module directory name
	 */
	function loadModuleLanguage($dirname)
	{
		$this->_loadLanguage($dirname, "main");
	}

	function loadModuleAdminLanguage($dirname)
	{
		$this->_loadLanguage($dirname, "admin");
	}

	function loadBlockLanguage($dirname)
	{
		$this->_loadLanguage($dirname, "blocks");
	}

	function loadManifestoLanguage($dirname)
	{
		$this->_loadLanguage($dirname, "modinfo");
	}

	/**
	 * @access private
	 * @param $dirname module directory name
	 * @param $fileBodyName language file body name
	 */
	function _loadLanguage($dirname, $fileBodyName)
	{
		$fileName = XOOPS_MODULE_PATH . "/" . $dirname . "/language/" . $this->mLanguageName . "/" . $fileBodyName . ".php";
		if (!$this->_loadFile($fileName)) {
			$fileName = XOOPS_ROOT_PATH . "/" . $dirname . "/language/english/" . $fileBodyName . ".php";
			$this->_loadFile($fileName);
		}
	}


	/**
	 * @access private
	 */
	function _loadFile($filename)
	{
		if (file_exists($filename)) {
			global $xoopsDB, $xoopsTpl, $xoopsRequestUri, $xoopsModule, $xoopsModuleConfig,
				   $xoopsModuleUpdate, $xoopsUser, $xoopsUserIsAdmin, $xoopsTheme,
				   $xoopsConfig, $xoopsOption, $xoopsCachedTemplate, $xoopsLogger, $xoopsDebugger;

			require_once $filename;
			return true;
		}

		return false;
	}
}

?>