<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . '/include/comment_constants.php';
require_once XOOPS_ROOT_PATH . '/modules/system/constants.php';

class BaseCommentstatusObject extends XoopsSimpleObject
{
	function BaseCommentstatusObject()
	{
		$this->initVar('id', XOBJ_DTYPE_INT, '', true);
		$this->initVar('name', XOBJ_DTYPE_STRING, '', true, 255);
	}
}

class BaseCommentstatusHandler extends XoopsObjectHandler
{
	var $_mResults = array();
	
	function BaseCommentstatusHandler(&$db)
	{
		$root =& XCube_Root::getSingleton();
		$language = $root->mController->getConfig('language');
		include_once XOOPS_ROOT_PATH . '/language/' . $language . '/comment.php';

		$this->_mResults[XOOPS_COMMENT_PENDING] =& $this->create();
		$this->_mResults[XOOPS_COMMENT_PENDING]->setVar('id', XOOPS_COMMENT_PENDING);
		$this->_mResults[XOOPS_COMMENT_PENDING]->setVar('name', _CM_PENDING);
		
		$this->_mResults[XOOPS_COMMENT_ACTIVE] =& $this->create();
		$this->_mResults[XOOPS_COMMENT_ACTIVE]->setVar('id', XOOPS_COMMENT_ACTIVE);
		$this->_mResults[XOOPS_COMMENT_ACTIVE]->setVar('name', _CM_ACTIVE);

		$this->_mResults[XOOPS_COMMENT_HIDDEN] =& $this->create();
		$this->_mResults[XOOPS_COMMENT_HIDDEN]->setVar('id', XOOPS_COMMENT_HIDDEN);
		$this->_mResults[XOOPS_COMMENT_HIDDEN]->setVar('name', _CM_HIDDEN);
	}
	
	function &create()
	{
		$ret =& new BaseCommentstatusObject();
		return $ret;
	}
	
	function get($id)
	{
		if (isset($this->_mResults[$id])) {
			return $this->_mResults[$id];
		}
		
		$ret = null;
		return $ret;
	}
	
	function &getObjects($criteria = null, $id_as_key = false)
	{
		if ($id_as_key) {
			return $this->_mResults;
		}
		else {
			$ret = array();
		
			foreach (array_keys($this->_mResults) as $key) {
				$ret[] =& $this->_mResults[$key];
			}
			
			return $ret;
		}
	}
	
	function insert(&$obj)
	{
		return false;
	}

	function delete(&$obj)
	{
		return false;
	}
}

?>
