<?php
/**
 * @version $Id: ModuleInstallAction.class.php,v 1.1.2.7 2006/04/16 02:10:50 minahito Exp $
 */

 if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_BASE_PATH."/admin/actions/AbstractModuleInstallAction.class.php";
require_once XOOPS_BASE_PATH."/admin/class/ModuleInstaller.class.php";
require_once XOOPS_BASE_PATH."/admin/forms/ModuleInstallForm.class.php";

/**
 * Install module
 */
class Legacy_ModuleInstallAction extends Legacy_AbstractModuleInstallAction
{
	var $mLicence;
	var $mLicenceText;

	function &_getInstaller($dirname)
	{
		$installer =& new Legacy_ModuleInstaller($dirname);
		return $installer;
	}
	
	function _setupActionForm()
	{
		$this->mActionForm =& new Legacy_ModuleInstallForm();
		$this->mActionForm->prepare();
	}

	function _loadAgreement()
	{
		$root =& XCube_Root::getSingleton();
		
		$this->mLicence = $this->mModuleObject->modinfo['installer']['licence']['title'];

		$file = $this->mModuleObject->modinfo['installer']['licence']['file'];
		$language = $root->mController->getConfig('language');

		$path = XOOPS_MODULE_PATH . "/" . $this->mModuleObject->getVar('dirname') ."/language/" . $language . "/" . $file;
		if (!file_exists($path)) {
			$path = XOOPS_MODULE_PATH . "/" . $this->mModuleObject->getVar('dirname') . "/language/english/" . $file;
			if (!file_exists($path)) {
				return;
			}
		}

		$this->mLicenceText = file_get_contents($path);
	}
	
	function executeViewSuccess(&$controller,&$xoopsUser,&$renderer)
	{
		$renderer->setTemplateName("module_install_success.html");
		$renderer->setAttribute('log', $this->mLog->mMessages);
	}

	function executeViewIndex(&$controller,&$xoopsUser,&$renderer)
	{
		$renderer->setAttribute('module', $this->mModuleObject);
		$renderer->setAttribute('actionForm', $this->mActionForm);

		if (isset($this->mModuleObject->modinfo['installer'])) {
			//
			// Jump
			//
			$controller->executeForward('index.php?action=InstallWizard&dirname=' . $this->mModuleObject->get('dirname'));
		}
		else {
			$renderer->setTemplateName("module_install.html");
		}
	}

	function executeViewInput(&$controller, &$xoopsUser, &$renderer)
	{
		$renderer->setTemplateName("module_install.html");
		$renderer->setAttribute('module', $this->mModuleObject);
		$renderer->setAttribute('actionForm', $this->mActionForm);
	}
}

?>