<?php

/*
 * Smarty plugin
 * -------------------------------------------------------------
 * Type:     function
 * Name:     xoops_dhtmltarea
 * Version:  1.0
 * Date:     Jun 6, 2004
 * Author:   minahito
 * Purpose:  cycle through given values
 * Input:    name = name of form 'name'
 *           values = preset value
 *           cols = default 50
 *           rows = default 5
 * 
 * Examples: {xoopsdhtmltarea name=message cols=40 rows=6 value=$message}
 * -------------------------------------------------------------
 */
function smarty_function_xoops_dhtmltarea($params, &$smarty)
{
	if (!class_exists('xoopsformelement')) {
		require_once XOOPS_ROOT_PATH."/class/xoopsformloader.php";
	}
	$form=null;

	if(isset($params['name'])) {
		$name = trim($params['name']);
		$rows = isset($params['rows']) ? intval($params['rows']) : 5;
		$cols = isset($params['cols']) ? intval($params['cols']) : 50;
		$value = isset($params['value']) ? trim($params['value']) : "";
		$form= new XoopsFormDhtmlTextArea($name,$name,htmlspecialchars($value),$rows,$cols);
		print $form->render();
	}
}

?>
